/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jackson.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.ArrayList;
import java.util.List;
import org.linguafranca.pwdb.PropertyValue;
import org.linguafranca.pwdb.kdbx.jackson.JacksonEntry;
import org.linguafranca.pwdb.kdbx.jackson.converter.BooleanToStringConverter;
import org.linguafranca.pwdb.kdbx.jackson.converter.StringToBooleanConverter;

public abstract class EntryClasses {
    public static StringProperty getStringProperty(String name, List<StringProperty> string) {
        for (StringProperty property : string) {
            if (!property.key.equals(name)) continue;
            return property;
        }
        return null;
    }

    public static BinaryProperty getBinaryProp(String name, List<BinaryProperty> binary) {
        for (BinaryProperty property : binary) {
            if (!property.key.equals(name)) continue;
            return property;
        }
        return null;
    }

    public static String getBinaryContent(BinaryProperty property) {
        return property == null || property.value == null ? null : property.value.ref;
    }

    public static class History {
        @JacksonXmlProperty(localName="Entry")
        @JacksonXmlElementWrapper(useWrapping=false)
        private List<JacksonEntry> list = new ArrayList<JacksonEntry>();

        public List<JacksonEntry> getHistory() {
            return this.list;
        }
    }

    public static class BinaryProperty {
        @JacksonXmlProperty(localName="Key")
        String key;
        @JacksonXmlProperty(localName="Value")
        Value value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Value value) {
            this.value = value;
        }

        public static class Value {
            @JacksonXmlProperty(localName="Ref", isAttribute=true)
            String ref;

            public void setRef(String ref) {
                this.ref = ref;
            }
        }
    }

    public static class StringProperty {
        @JacksonXmlProperty(localName="Key")
        String key;
        @JacksonXmlProperty(localName="Value")
        PropertyValue value;

        public StringProperty() {
        }

        public StringProperty(String key, PropertyValue value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public PropertyValue getValue() {
            return this.value;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(PropertyValue value) {
            this.value = value;
        }
    }

    public static class AutoType {
        @JacksonXmlProperty(localName="Enabled")
        @JsonDeserialize(converter=StringToBooleanConverter.class)
        @JsonSerialize(converter=BooleanToStringConverter.class)
        protected Boolean enabled;
        @JacksonXmlProperty(localName="DataTransferObfuscation")
        protected int dataTransferObfuscation;
        @JacksonXmlProperty(localName="DefaultSequence")
        protected String defaultSequence;
        @JacksonXmlProperty(localName="Association")
        protected Association association;

        public static class Association {
            @JacksonXmlProperty(localName="Window")
            protected String window;
            @JacksonXmlProperty(localName="KeystrokeSequence")
            protected String keystrokeSequence;
            protected List<Object> windowAndKeystrokeSequence;
        }
    }
}

