/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jaxb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.linguafranca.pwdb.base.AbstractGroup;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbDatabase;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbEntry;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbIcon;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbEntryBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbGroupBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.ObjectFactory;

public class JaxbGroup
extends AbstractGroup<JaxbDatabase, JaxbGroup, JaxbEntry, JaxbIcon> {
    protected JaxbDatabase database;
    protected JaxbGroupBinding delegate;

    public JaxbGroup(JaxbDatabase database, JaxbGroupBinding group) {
        this.delegate = group;
        this.database = database;
    }

    public JaxbGroup(JaxbDatabase database) {
        this.database = database;
        this.delegate = database.getObjectFactory().createJaxbGroupBinding();
        this.delegate.setTimes(new ObjectFactory().createTimes());
        this.delegate.setIconID(0);
        this.delegate.setName("");
        this.delegate.setUUID(UUID.randomUUID());
    }

    public boolean isRootGroup() {
        return this.database.getRootGroup().equals((Object)this);
    }

    public JaxbGroup getParent() {
        if (this.delegate.parent == null) {
            return null;
        }
        return new JaxbGroup(this.database, (JaxbGroupBinding)this.delegate.parent);
    }

    public void setParent(JaxbGroup group) {
        if (this.isRootGroup()) {
            throw new IllegalStateException("Cannot add root group to another group");
        }
        if (this.database != group.database) {
            throw new IllegalStateException("Must be from same database");
        }
        JaxbGroupBinding parent = (JaxbGroupBinding)group.delegate.parent;
        if (parent != null) {
            parent.getGroup().remove(group.delegate);
            parent.getTimes().setLastModificationTime(new Date());
        }
        this.delegate.parent = group.delegate;
        ((JaxbGroupBinding)this.delegate.parent).getTimes().setLastModificationTime(new Date());
        this.touch();
    }

    public List<JaxbGroup> getGroups() {
        ArrayList<JaxbGroup> result = new ArrayList<JaxbGroup>();
        for (JaxbGroupBinding child : this.delegate.getGroup()) {
            result.add(new JaxbGroup(this.database, child));
        }
        return result;
    }

    public int getGroupsCount() {
        return this.delegate.getGroup().size();
    }

    public JaxbGroup addGroup(JaxbGroup group) {
        if (group.isRootGroup()) {
            throw new IllegalStateException("Cannot add root group to another group");
        }
        if (this.database != group.database) {
            throw new IllegalStateException("Must be from same database");
        }
        if (group.getParent() != null) {
            group.getParent().delegate.getGroup().remove(group.delegate);
        }
        group.delegate.parent = this.delegate;
        this.delegate.getGroup().add(group.delegate);
        this.touch();
        return group;
    }

    public JaxbGroup removeGroup(JaxbGroup group) {
        if (this.database != group.database) {
            throw new IllegalStateException("Must be from same database");
        }
        this.delegate.getGroup().remove(group.delegate);
        group.delegate.parent = null;
        this.touch();
        return group;
    }

    public List<JaxbEntry> getEntries() {
        ArrayList<JaxbEntry> result = new ArrayList<JaxbEntry>();
        for (JaxbEntryBinding entry : this.delegate.getEntry()) {
            result.add(new JaxbEntry(this.database, entry));
        }
        return result;
    }

    public int getEntriesCount() {
        return this.delegate.getEntry().size();
    }

    public JaxbEntry addEntry(JaxbEntry entry) {
        if (this.database != entry.database) {
            throw new IllegalStateException("Must be from same database");
        }
        if (entry.getParent() != null) {
            entry.getParent().removeEntry(entry);
        }
        this.delegate.getEntry().add(entry.delegate);
        entry.delegate.parent = this.delegate;
        this.touch();
        return entry;
    }

    public JaxbEntry removeEntry(JaxbEntry entry) {
        this.delegate.getEntry().remove(entry.delegate);
        entry.delegate.parent = null;
        return entry;
    }

    public String getName() {
        return this.delegate.getName();
    }

    public void setName(String name) {
        this.delegate.setName(name);
    }

    public UUID getUuid() {
        return this.delegate.getUUID();
    }

    public JaxbIcon getIcon() {
        return new JaxbIcon(this.delegate.getIconID());
    }

    public void setIcon(JaxbIcon icon) {
        this.delegate.setIconID(icon.getIndex());
    }

    public JaxbDatabase getDatabase() {
        return this.database;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JaxbGroup that = (JaxbGroup)((Object)o);
        return ((Object)((Object)this.database)).equals((Object)that.database) && this.delegate.equals(that.delegate);
    }

    private void touch() {
        this.delegate.getTimes().setLastModificationTime(new Date());
        this.database.setDirty(true);
    }
}

