/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdbx.SerializableDatabase;
import org.linguafranca.pwdb.kdbx.StreamFormat;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbEntry;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbGroup;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbIcon;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbSerializableDatabase;
import org.linguafranca.pwdb.kdbx.jaxb.binding.KeePassFile;
import org.linguafranca.pwdb.kdbx.jaxb.binding.ObjectFactory;
import org.linguafranca.pwdb.kdbx.stream_3_1.KdbxStreamFormat;

public class JaxbDatabase
extends AbstractDatabase<JaxbDatabase, JaxbGroup, JaxbEntry, JaxbIcon> {
    private KeePassFile keePassFile;
    private ObjectFactory objectFactory = new ObjectFactory();
    private JaxbGroup root;

    public JaxbDatabase() {
        this(JaxbDatabase.createEmptyDatabase().getKeePassFile());
    }

    public JaxbDatabase(KeePassFile keePassFile) {
        this.keePassFile = keePassFile;
        this.root = new JaxbGroup(this, keePassFile.getRoot().getGroup());
    }

    public static JaxbDatabase createEmptyDatabase() {
        InputStream inputStream = JaxbDatabase.class.getClassLoader().getResourceAsStream("base.kdbx.xml");
        KeePassFile keePassFile = new JaxbSerializableDatabase().load((InputStream)inputStream).keePassFile;
        keePassFile.getRoot().getGroup().setUUID(UUID.randomUUID());
        return new JaxbDatabase(keePassFile);
    }

    public static JaxbDatabase load(Credentials creds, InputStream inputStream) {
        KdbxStreamFormat format = new KdbxStreamFormat();
        return JaxbDatabase.load((StreamFormat)format, creds, inputStream);
    }

    @NotNull
    public static JaxbDatabase load(StreamFormat format, Credentials creds, InputStream inputStream) {
        JaxbSerializableDatabase db = new JaxbSerializableDatabase();
        try {
            format.load((SerializableDatabase)db, creds, inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new JaxbDatabase(db.getKeePassFile());
    }

    public void save(Credentials creds, OutputStream outputStream) throws IOException {
        this.save((StreamFormat)new KdbxStreamFormat(), creds, outputStream);
    }

    public void save(StreamFormat format, Credentials creds, OutputStream outputStream) throws IOException {
        JaxbSerializableDatabase jsd = new JaxbSerializableDatabase();
        jsd.setKeePassFile(this.keePassFile);
        format.save((SerializableDatabase)jsd, creds, outputStream);
        this.setDirty(false);
    }

    public JaxbGroup getRootGroup() {
        return this.root;
    }

    public JaxbGroup newGroup() {
        return new JaxbGroup(this);
    }

    public JaxbEntry newEntry() {
        return new JaxbEntry(this);
    }

    public JaxbIcon newIcon() {
        return new JaxbIcon();
    }

    public JaxbIcon newIcon(Integer i) {
        return new JaxbIcon(i);
    }

    public String getDescription() {
        return this.keePassFile.getMeta().getDatabaseDescription();
    }

    public void setDescription(String description) {
        this.keePassFile.getMeta().setDatabaseDescription(description);
    }

    public boolean shouldProtect(String propertyName) {
        switch (propertyName.toLowerCase()) {
            case "title": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectTitle();
            }
            case "username": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectUserName();
            }
            case "password": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectPassword();
            }
            case "url": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectURL();
            }
            case "notes": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectNotes();
            }
        }
        return false;
    }

    public String getName() {
        return this.keePassFile.getMeta().getDatabaseName();
    }

    public void setName(String s) {
        this.keePassFile.getMeta().setDatabaseName(s);
        this.keePassFile.getMeta().setDatabaseNameChanged(new Date());
    }

    public KeePassFile getKeePassFile() {
        return this.keePassFile;
    }

    ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }
}

