/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.SerializableDatabase;
import org.linguafranca.pwdb.StreamConfiguration;
import org.linguafranca.pwdb.StreamFormat;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdbx.KdbxHeader;
import org.linguafranca.pwdb.kdbx.KdbxStreamFormat;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbEntry;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbGroup;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbIcon;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbSerializableDatabase;
import org.linguafranca.pwdb.kdbx.jaxb.binding.KeePassFile;
import org.linguafranca.pwdb.kdbx.jaxb.binding.ObjectFactory;

public class JaxbDatabase
extends AbstractDatabase<JaxbDatabase, JaxbGroup, JaxbEntry, JaxbIcon> {
    private final KeePassFile keePassFile;
    private final ObjectFactory objectFactory = new ObjectFactory();
    private final JaxbGroup root;
    private StreamFormat<?> streamFormat;

    public JaxbDatabase() {
        this(JaxbDatabase.createEmptyDatabase().getKeePassFile(), null);
    }

    private JaxbDatabase(KeePassFile keePassFile, StreamFormat<?> streamFormat) {
        this.keePassFile = keePassFile;
        this.root = new JaxbGroup(this, keePassFile.getRoot().getGroup());
        this.streamFormat = streamFormat;
    }

    public static JaxbDatabase createEmptyDatabase() {
        InputStream inputStream = JaxbDatabase.class.getClassLoader().getResourceAsStream("base.kdbx.xml");
        KeePassFile keePassFile = new JaxbSerializableDatabase().load((InputStream)inputStream).keePassFile;
        keePassFile.getRoot().getGroup().setUUID(UUID.randomUUID());
        return new JaxbDatabase(keePassFile, null);
    }

    public static JaxbDatabase load(Credentials creds, InputStream inputStream) throws IOException {
        return JaxbDatabase.load(new KdbxStreamFormat(), creds, inputStream);
    }

    @NotNull
    public static <C extends StreamConfiguration> JaxbDatabase load(StreamFormat<C> format, Credentials creds, InputStream inputStream) throws IOException {
        JaxbSerializableDatabase db = new JaxbSerializableDatabase();
        format.load((SerializableDatabase)db, creds, inputStream);
        return new JaxbDatabase(db.getKeePassFile(), format);
    }

    public void save(Credentials creds, OutputStream outputStream) throws IOException {
        if (Objects.isNull(this.streamFormat)) {
            this.streamFormat = new KdbxStreamFormat(new KdbxHeader(4));
        }
        this.save(this.streamFormat, creds, outputStream);
    }

    public <C extends StreamConfiguration> void save(StreamFormat<C> format, Credentials creds, OutputStream outputStream) throws IOException {
        this.keePassFile.getMeta().setGenerator("KeePassJava2-JAXB");
        JaxbSerializableDatabase jsd = new JaxbSerializableDatabase(this.keePassFile);
        format.save((SerializableDatabase)jsd, creds, outputStream);
        this.setDirty(false);
    }

    public JaxbGroup getRootGroup() {
        return this.root;
    }

    public JaxbGroup getRecycleBin() {
        UUID recycleBinUuid = this.keePassFile.getMeta().getRecycleBinUUID();
        JaxbGroup g = (JaxbGroup)this.findGroup(recycleBinUuid);
        if (g == null && !this.isRecycleBinEnabled()) {
            return null;
        }
        if (g == null) {
            g = (JaxbGroup)this.newGroup("Recycle Bin");
            this.getRootGroup().addGroup(g);
            this.keePassFile.getMeta().setRecycleBinUUID(g.getUuid());
            this.keePassFile.getMeta().setRecycleBinChanged(new Date());
        }
        return g;
    }

    public boolean isRecycleBinEnabled() {
        return this.keePassFile.getMeta().getRecycleBinEnabled();
    }

    public void enableRecycleBin(boolean enable) {
        this.keePassFile.getMeta().setRecycleBinEnabled(enable);
    }

    public JaxbGroup newGroup() {
        return new JaxbGroup(this);
    }

    public JaxbEntry newEntry() {
        return new JaxbEntry(this);
    }

    public JaxbIcon newIcon() {
        return new JaxbIcon();
    }

    public JaxbIcon newIcon(Integer i) {
        return new JaxbIcon(i);
    }

    public String getDescription() {
        return this.keePassFile.getMeta().getDatabaseDescription();
    }

    public void setDescription(String description) {
        this.keePassFile.getMeta().setDatabaseDescription(description);
    }

    public boolean shouldProtect(String propertyName) {
        switch (propertyName.toLowerCase()) {
            case "title": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectTitle();
            }
            case "username": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectUserName();
            }
            case "password": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectPassword();
            }
            case "url": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectURL();
            }
            case "notes": {
                return this.keePassFile.getMeta().getMemoryProtection().getProtectNotes();
            }
        }
        return false;
    }

    public String getName() {
        return this.keePassFile.getMeta().getDatabaseName();
    }

    public void setName(String s) {
        this.keePassFile.getMeta().setDatabaseName(s);
        this.keePassFile.getMeta().setDatabaseNameChanged(new Date());
    }

    public KeePassFile getKeePassFile() {
        return this.keePassFile;
    }

    ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public void createBinary(byte[] value, Integer index) {
        JaxbSerializableDatabase.addBinary(this.getKeePassFile(), this.getObjectFactory(), index, value);
    }

    public StreamFormat<?> getStreamFormat() {
        return this.streamFormat;
    }
}

