/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.UUID;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.Group;
import org.linguafranca.pwdb.Visitor;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdb.KdbEntry;
import org.linguafranca.pwdb.kdb.KdbGroup;
import org.linguafranca.pwdb.kdb.KdbHeader;
import org.linguafranca.pwdb.kdb.KdbIcon;
import org.linguafranca.pwdb.kdb.KdbSerializer;

public class KdbDatabase
extends AbstractDatabase<KdbDatabase, KdbGroup, KdbEntry, KdbIcon> {
    private String description;
    private KdbGroup rootGroup = new KdbGroup();
    static SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public KdbDatabase() {
        this.rootGroup.setRoot(true);
        this.rootGroup.setName("Root");
        this.rootGroup.setIcon(new KdbIcon(1));
        this.rootGroup.setUuid(UUID.randomUUID());
    }

    public static KdbDatabase load(Credentials credentials, InputStream inputStream) throws IOException {
        return KdbSerializer.createKdbDatabase(credentials, new KdbHeader(), inputStream);
    }

    public KdbGroup findGroup(UUID uuid) {
        GroupFinder groupFinder = new GroupFinder(uuid);
        this.visit((Visitor)groupFinder);
        return (KdbGroup)groupFinder.foundGroup;
    }

    public KdbGroup getRootGroup() {
        return this.rootGroup;
    }

    public KdbGroup newGroup() {
        return new KdbGroup();
    }

    public KdbEntry newEntry() {
        return new KdbEntry();
    }

    public KdbIcon newIcon() {
        return new KdbIcon(0);
    }

    public KdbIcon newIcon(Integer i) {
        return new KdbIcon(i);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void save(Credentials credentials, OutputStream outputStream) throws IOException {
        throw new UnsupportedOperationException("Cannot save KDB files in this implementation");
    }

    public boolean shouldProtect(String propertyName) {
        return false;
    }

    public String getName() {
        return null;
    }

    public void setName(String s) {
    }

    private static class GroupFinder
    extends Visitor.Default {
        Group foundGroup = null;
        UUID uuid;

        GroupFinder(UUID uuid) {
            if (uuid == null) {
                throw new IllegalArgumentException("UUID cannot be null");
            }
            this.uuid = uuid;
        }

        public void startVisit(Group group) {
            if (group != null && this.uuid.equals(group.getUuid())) {
                this.foundGroup = group;
            }
        }
    }
}

