/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.DigestInputStream;
import java.util.Arrays;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.linguafranca.pwdb.security.Encryption;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class KdbxKeyFile {
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private static final int BUFFER_SIZE = 65;
    private static final int KEY_LEN_32 = 32;
    private static final int KEY_LEN_64 = 64;

    public static byte[] load(InputStream inputStream) {
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, Encryption.getSha256MessageDigestInstance());
        PushbackInputStream pis = new PushbackInputStream(digestInputStream, 65);
        try {
            byte[] buffer = new byte[65];
            int bytesRead = pis.read(buffer);
            if (bytesRead == 32) {
                return Arrays.copyOf(buffer, bytesRead);
            }
            if (bytesRead == 64) {
                try {
                    ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
                    Charset charSet = StandardCharsets.UTF_8;
                    CharBuffer charBuffer = charSet.decode(byteBuffer);
                    charBuffer.limit(64);
                    char[] hexValue = new char[charBuffer.remaining()];
                    charBuffer.get(hexValue);
                    return Hex.decodeHex((char[])hexValue);
                }
                catch (DecoderException byteBuffer) {
                    // empty catch block
                }
            }
            pis.unread(buffer);
            try {
                return KdbxKeyFile.tryComputeXmlKeyFile(pis);
            }
            catch (HashMismatchException e) {
                throw new IllegalArgumentException("Invalid key in signature file");
            }
            catch (Exception e) {
                byte[] sink = new byte[1024];
                while (digestInputStream.read(sink) > 0) {
                }
                return digestInputStream.getMessageDigest().digest();
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static byte[] tryComputeXmlKeyFile(InputStream is) throws HashMismatchException {
        FilterInputStream unCloseable = new FilterInputStream(is){

            @Override
            public void close() {
            }
        };
        try {
            String hashToCheck;
            byte[] decodedHashToCheck;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.parse(unCloseable);
            String data = (String)xpath.evaluate("//KeyFile/Key/Data/text()", doc, XPathConstants.STRING);
            if (data == null) {
                throw new IllegalArgumentException("Key file does not contain a key");
            }
            String version = (String)xpath.evaluate("//KeyFile/Meta/Version/text()", doc, XPathConstants.STRING);
            if (Objects.isNull(version) || !version.equals("2.0")) {
                return Base64.decodeBase64((String)data);
            }
            byte[] decodedData = Hex.decodeHex((String)data.replaceAll("\\s", ""));
            byte[] decodedDataHash = Encryption.getSha256MessageDigestInstance().digest(decodedData);
            if (!Arrays.equals(Arrays.copyOf(decodedDataHash, (decodedHashToCheck = Hex.decodeHex((String)(hashToCheck = (String)xpath.evaluate("//KeyFile/Key/Data/@Hash", doc, XPathConstants.STRING)))).length), decodedHashToCheck)) {
                throw new HashMismatchException();
            }
            return decodedData;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | DecoderException | SAXException e) {
            throw new IllegalArgumentException("An error occurred during XML parsing: " + e.getMessage());
        }
    }

    private static class HashMismatchException
    extends Exception {
        private HashMismatchException() {
        }
    }
}

