/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.hashedblock;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.Arrays;
import javax.crypto.Mac;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.security.Encryption;

public class HmacBlockInputStream
extends FilterInputStream {
    private final ByteOrder byteOrder;
    private final byte[] key;
    private volatile ByteArrayInputStream bufferStream;
    private final DataInput input;
    private boolean finished;
    private int blockCount = 0;

    public HmacBlockInputStream(byte[] key, InputStream inputStream) throws IOException {
        this(key, inputStream, false);
    }

    public HmacBlockInputStream(byte[] key, InputStream inputStream, boolean littleEndian) throws IOException {
        super(inputStream);
        this.byteOrder = littleEndian ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        this.key = key;
        this.input = littleEndian ? new LittleEndianDataInputStream(this.in) : new DataInputStream(this.in);
        this.getBlock();
    }

    private void getBlock() throws IOException {
        byte[] hmacSha256 = new byte[32];
        this.input.readFully(hmacSha256);
        int blockSize = this.input.readInt();
        if (blockSize == 0) {
            this.finished = true;
        }
        byte[] buffer = new byte[blockSize];
        this.input.readFully(buffer);
        this.verifyHmac(buffer, this.blockCount, hmacSha256);
        this.bufferStream = new ByteArrayInputStream(buffer);
        ++this.blockCount;
    }

    private void verifyHmac(byte[] buffer, long blockNumber, byte[] hmacSha256) {
        byte[] transformedKey = Encryption.transformHmacKey((byte[])this.key, (byte[])Helpers.toBytes(blockNumber, this.byteOrder));
        Mac mac = Encryption.getHMacSha256Instance((byte[])transformedKey);
        mac.update(Helpers.toBytes(blockNumber, this.byteOrder));
        mac.update(Helpers.toBytes(buffer.length, this.byteOrder));
        if (!Arrays.equals(mac.doFinal(buffer), hmacSha256)) {
            throw new IllegalStateException("Block HMAC does not match");
        }
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        if (this.finished) {
            return -1;
        }
        int bytesRead = this.bufferStream.read(b, off, len);
        if (this.bufferStream.available() == 0) {
            this.getBlock();
        }
        return bytesRead;
    }

    @Override
    public int read() throws IOException {
        if (this.finished) {
            return -1;
        }
        int result = this.bufferStream.read();
        if (result == -1) {
            this.getBlock();
            if (this.finished) {
                return -1;
            }
            result = this.bufferStream.read();
            if (result == -1) {
                throw new IOException("Can't replenish buffer");
            }
        }
        return result;
    }
}

