/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx;

import com.fasterxml.aalto.stax.EventFactoryImpl;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.StreamEncryptor;
import org.linguafranca.xml.XmlEventTransformer;

public class KdbxInputTransformer
implements XmlEventTransformer {
    private XMLEventFactory xmlEventFactory = new EventFactoryImpl();
    private final StreamEncryptor streamEncryptor;
    private boolean decryptContent;

    public KdbxInputTransformer(StreamEncryptor streamEncryptor) {
        this.streamEncryptor = streamEncryptor;
    }

    @Override
    public XMLEvent transform(XMLEvent event) {
        switch (event.getEventType()) {
            case 1: {
                Attribute attribute = event.asStartElement().getAttributeByName(new QName("Protected"));
                if (attribute == null) break;
                this.decryptContent = Helpers.toBoolean((String)attribute.getValue());
                break;
            }
            case 2: {
                this.decryptContent = false;
                break;
            }
            case 4: {
                if (!this.decryptContent) break;
                String text = event.asCharacters().getData();
                text = new String(this.streamEncryptor.decrypt(Helpers.decodeBase64Content((byte[])text.getBytes(), (boolean)false)));
                event = this.xmlEventFactory.createCharacters(text);
            }
        }
        return event;
    }
}

