/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx;

import com.fasterxml.aalto.stax.EventFactoryImpl;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.StreamEncryptor;
import org.linguafranca.xml.XmlEventTransformer;

public class KdbxOutputTransformer
implements XmlEventTransformer {
    private XMLEventFactory eventFactory = EventFactoryImpl.newInstance();
    private StreamEncryptor encryptor;
    private Boolean encryptContent = false;

    public KdbxOutputTransformer(StreamEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public XMLEvent transform(XMLEvent event) {
        switch (event.getEventType()) {
            case 1: {
                Attribute attribute = event.asStartElement().getAttributeByName(new QName("Protected"));
                if (attribute == null) break;
                this.encryptContent = Helpers.toBoolean((String)attribute.getValue());
                break;
            }
            case 4: {
                if (!this.encryptContent.booleanValue()) break;
                String unencrypted = event.asCharacters().getData();
                String encrypted = Helpers.encodeBase64Content((byte[])this.encryptor.encrypt(unencrypted.getBytes()), (boolean)false);
                event = this.eventFactory.createCharacters(encrypted);
                break;
            }
            case 2: {
                this.encryptContent = false;
            }
        }
        return event;
    }
}

