/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdbx.KdbxInputTransformer;
import org.linguafranca.pwdb.kdbx.KdbxOutputTransformer;
import org.linguafranca.pwdb.kdbx.StreamEncryptor;
import org.linguafranca.pwdb.kdbx.simple.SimpleEntry;
import org.linguafranca.pwdb.kdbx.simple.SimpleGroup;
import org.linguafranca.pwdb.kdbx.simple.SimpleIcon;
import org.linguafranca.pwdb.kdbx.simple.converter.EmptyStringConverter;
import org.linguafranca.pwdb.kdbx.simple.model.EntryClasses;
import org.linguafranca.pwdb.kdbx.simple.model.KeePassFile;
import org.linguafranca.pwdb.kdbx.stream_3_1.KdbxHeader;
import org.linguafranca.pwdb.kdbx.stream_3_1.KdbxSerializer;
import org.linguafranca.pwdb.kdbx.stream_3_1.Salsa20StreamEncryptor;
import org.linguafranca.xml.XmlInputStreamFilter;
import org.linguafranca.xml.XmlOutputStreamFilter;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.convert.RegistryStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;

public class SimpleDatabase
extends AbstractDatabase<SimpleDatabase, SimpleGroup, SimpleEntry, SimpleIcon> {
    private KeePassFile keePassFile;

    public SimpleDatabase() {
        try {
            this.keePassFile = SimpleDatabase.createEmptyDatabase();
            this.keePassFile.root.group.database = this;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected SimpleDatabase(KeePassFile keePassFile) {
        this.keePassFile = keePassFile;
        this.keePassFile.root.group.database = this;
        SimpleDatabase.fixUp(this.keePassFile.root.group);
    }

    public SimpleGroup getRootGroup() {
        return this.keePassFile.root.getGroup();
    }

    public SimpleGroup newGroup() {
        return SimpleGroup.createGroup(this);
    }

    public SimpleEntry newEntry() {
        return SimpleEntry.createEntry(this);
    }

    public SimpleIcon newIcon() {
        return new SimpleIcon();
    }

    public SimpleIcon newIcon(Integer integer) {
        SimpleIcon ic = this.newIcon();
        ic.setIndex(integer);
        return ic;
    }

    public String getName() {
        return this.keePassFile.meta.databaseName;
    }

    public void setName(String s) {
        this.keePassFile.meta.databaseName = s;
        this.keePassFile.meta.databaseNameChanged = new Date();
        this.setDirty(true);
    }

    public String getDescription() {
        return this.keePassFile.meta.databaseDescription;
    }

    public void setDescription(String s) {
        this.keePassFile.meta.databaseDescription = s;
        this.keePassFile.meta.databaseDescriptionChanged = new Date();
        this.setDirty(true);
    }

    private static KeePassFile createEmptyDatabase() throws Exception {
        InputStream inputStream = SimpleDatabase.class.getClassLoader().getResourceAsStream("base.kdbx.xml");
        return (KeePassFile)SimpleDatabase.getSerializer().read(KeePassFile.class, inputStream);
    }

    public static SimpleDatabase loadXml(InputStream inputStream) throws Exception {
        KeePassFile result = (KeePassFile)SimpleDatabase.getSerializer().read(KeePassFile.class, inputStream);
        result.root.group.uuid = UUID.randomUUID();
        return new SimpleDatabase(result);
    }

    public static SimpleDatabase load(Credentials credentials, InputStream inputStream) throws Exception {
        KdbxHeader kdbxHeader = new KdbxHeader();
        InputStream kdbxInnerStream = KdbxSerializer.createUnencryptedInputStream((Credentials)credentials, (KdbxHeader)kdbxHeader, (InputStream)inputStream);
        XmlInputStreamFilter plainTextXmlStream = new XmlInputStreamFilter(kdbxInnerStream, new KdbxInputTransformer((StreamEncryptor)new Salsa20StreamEncryptor(kdbxHeader.getProtectedStreamKey())));
        KeePassFile result = (KeePassFile)SimpleDatabase.getSerializer().read(KeePassFile.class, (InputStream)plainTextXmlStream);
        if (!Arrays.equals(result.meta.headerHash.getContent(), kdbxHeader.getHeaderHash())) {
            throw new IllegalStateException("Header Hash Mismatch");
        }
        return new SimpleDatabase(result);
    }

    public void save(OutputStream outputStream) {
        try {
            SimpleDatabase.prepareForSave(this.keePassFile.root.group);
            SimpleDatabase.getSerializer().write((Object)this.keePassFile, outputStream);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void save(Credentials credentials, OutputStream outputStream) throws IOException {
        try {
            KdbxHeader kdbxHeader = new KdbxHeader();
            OutputStream kdbxInnerStream = KdbxSerializer.createEncryptedOutputStream((Credentials)credentials, (KdbxHeader)kdbxHeader, (OutputStream)outputStream);
            this.keePassFile.meta.headerHash.setContent(kdbxHeader.getHeaderHash());
            XmlOutputStreamFilter plainTextOutputStream = new XmlOutputStreamFilter(kdbxInnerStream, new KdbxOutputTransformer((StreamEncryptor)new Salsa20StreamEncryptor(kdbxHeader.getProtectedStreamKey())));
            SimpleDatabase.prepareForSave(this.keePassFile.root.group);
            SimpleDatabase.getSerializer().write((Object)this.keePassFile, (OutputStream)plainTextOutputStream);
            plainTextOutputStream.close();
            plainTextOutputStream.await();
            this.setDirty(false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean shouldProtect(String s) {
        return this.keePassFile.meta.memoryProtection.shouldProtect(s);
    }

    public List<KeePassFile.Binaries.Binary> getBinaries() {
        return this.keePassFile.getBinaries();
    }

    private static Serializer getSerializer() throws Exception {
        Registry registry = new Registry();
        registry.bind(String.class, EmptyStringConverter.class);
        AnnotationStrategy strategy = new AnnotationStrategy((Strategy)new RegistryStrategy(registry));
        return new Persister((Strategy)strategy);
    }

    private static void fixUp(SimpleGroup parent) {
        for (SimpleGroup group : parent.group) {
            group.parent = parent;
            group.database = parent.database;
            SimpleDatabase.fixUp(group);
        }
        for (SimpleEntry entry : parent.entry) {
            entry.database = parent.database;
            entry.parent = parent;
        }
    }

    private static void prepareForSave(SimpleGroup parent) {
        for (SimpleGroup group : parent.group) {
            SimpleDatabase.prepareForSave(group);
        }
        for (SimpleEntry entry : parent.entry) {
            for (EntryClasses.StringProperty property : entry.string) {
                boolean shouldProtect = parent.database.shouldProtect(property.getKey());
                property.getValue().setProtected(shouldProtect);
            }
        }
    }
}

