/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple.model;

import java.util.List;
import org.linguafranca.pwdb.kdbx.simple.SimpleEntry;
import org.linguafranca.pwdb.kdbx.simple.converter.KeePassBooleanConverter;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.Text;
import org.simpleframework.xml.convert.Convert;
import org.simpleframework.xml.util.Entry;

public abstract class EntryClasses {
    public static StringProperty getStringProperty(String name, List<StringProperty> string) {
        for (StringProperty property : string) {
            if (!property.key.equals(name)) continue;
            return property;
        }
        return null;
    }

    public static String getStringContent(StringProperty property) {
        return property == null || property.value == null ? null : property.value.text;
    }

    public static BinaryProperty getBinaryProp(String name, List<BinaryProperty> binary) {
        for (BinaryProperty property : binary) {
            if (!property.key.equals(name)) continue;
            return property;
        }
        return null;
    }

    public static String getBinaryContent(BinaryProperty property) {
        return property == null || property.value == null ? null : property.value.ref;
    }

    @Root(name="History")
    public static class History {
        @Element(name="SimpleEntry", required=false)
        protected SimpleEntry entry;
    }

    @Root(name="Binary")
    public static class BinaryProperty
    implements Entry {
        @Element(name="Key")
        protected String key;
        @Element(name="Value")
        protected Value value;

        public String getKey() {
            return this.key;
        }

        public String getName() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(Value value) {
            this.value = value;
        }

        @Root(name="Value")
        public static class Value {
            @Attribute(name="Ref")
            protected String ref;

            public void setRef(String ref) {
                this.ref = ref;
            }
        }
    }

    @Root(name="String")
    public static class StringProperty
    implements Entry {
        @Element(name="Key")
        protected String key;
        @Element(name="Value")
        protected Value value;

        public StringProperty() {
            this("", new Value());
        }

        public StringProperty(String key, Value value) {
            this.key = key;
            this.value = value;
        }

        public String getName() {
            return this.key;
        }

        public String getKey() {
            return this.key;
        }

        public Value getValue() {
            return this.value;
        }

        @Root(name="Value")
        public static class Value {
            @Attribute(name="ProtectInMemory", required=false)
            @Convert(value=KeePassBooleanConverter.class)
            protected Boolean protectInMemory;
            @Attribute(name="Protected", required=false)
            @Convert(value=KeePassBooleanConverter.class)
            protected Boolean _protected;
            @Text
            protected String text;

            public Value() {
                this("");
            }

            public Value(String text) {
                this.text = text;
                this._protected = false;
            }

            public Value(String text, Boolean _protected) {
                this._protected = _protected;
                this.text = text;
            }

            public void setProtected(boolean aProtected) {
                this._protected = aProtected;
            }
        }
    }

    @Root(name="AutoType")
    public static class AutoType {
        @Element(name="Enabled", type=Boolean.class)
        @Convert(value=KeePassBooleanConverter.class)
        protected Boolean enabled;
        @Element(name="DataTransferObfuscation")
        protected int dataTransferObfuscation;
        @Element(name="DefaultSequence", required=false)
        protected String defaultSequence;
        @Element(name="Association", required=false)
        protected Association association;

        public static class Association {
            @Element(name="Window")
            protected String window;
            @Element(name="KeystrokeSequence")
            protected String keystrokeSequence;
            protected List<Object> windowAndKeystrokeSequence;
        }
    }
}

