/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.SerializableDatabase;
import org.linguafranca.pwdb.StreamConfiguration;
import org.linguafranca.pwdb.StreamFormat;
import org.linguafranca.pwdb.base.AbstractDatabase;
import org.linguafranca.pwdb.kdbx.KdbxHeader;
import org.linguafranca.pwdb.kdbx.KdbxStreamFormat;
import org.linguafranca.pwdb.kdbx.simple.SimpleEntry;
import org.linguafranca.pwdb.kdbx.simple.SimpleGroup;
import org.linguafranca.pwdb.kdbx.simple.SimpleIcon;
import org.linguafranca.pwdb.kdbx.simple.SimpleSerializableDatabase;
import org.linguafranca.pwdb.kdbx.simple.model.KeePassFile;
import org.linguafranca.pwdb.security.StreamEncryptor;

public class SimpleDatabase
extends AbstractDatabase<SimpleDatabase, SimpleGroup, SimpleEntry, SimpleIcon> {
    KeePassFile keePassFile;
    StreamFormat<?> streamFormat;

    public SimpleDatabase() {
        this(SimpleSerializableDatabase.createEmptyDatabase(), null);
    }

    public SimpleDatabase(KeePassFile file, StreamFormat<?> streamFormat) {
        try {
            this.keePassFile = file;
            this.keePassFile.root.group.database = this;
            this.streamFormat = streamFormat;
            SimpleSerializableDatabase.fixUp(this.keePassFile.root.group);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static SimpleDatabase loadXml(InputStream inputStream) throws Exception {
        KeePassFile result = (KeePassFile)SimpleSerializableDatabase.getSerializer((StreamEncryptor)new StreamEncryptor.None()).read(KeePassFile.class, inputStream);
        result.root.group.uuid = UUID.randomUUID();
        return new SimpleDatabase(result, null);
    }

    public static SimpleDatabase load(Credentials credentials, InputStream inputStream) throws IOException {
        SimpleSerializableDatabase simpleSerializableDatabase = new SimpleSerializableDatabase();
        KdbxStreamFormat streamFormat = new KdbxStreamFormat();
        streamFormat.load((SerializableDatabase)simpleSerializableDatabase, credentials, inputStream);
        return new SimpleDatabase(simpleSerializableDatabase.getKeePassFile(), (StreamFormat<?>)streamFormat);
    }

    public void save(Credentials credentials, OutputStream outputStream) throws IOException {
        if (Objects.isNull(this.streamFormat)) {
            this.streamFormat = new KdbxStreamFormat(new KdbxHeader(4));
        }
        this.save(this.streamFormat, credentials, outputStream);
    }

    public <C extends StreamConfiguration> void save(StreamFormat<C> streamFormat, Credentials credentials, OutputStream outputStream) throws IOException {
        this.keePassFile.meta.generator = "KeePassJava2-Simple";
        SimpleSerializableDatabase simpleSerializableDatabase = new SimpleSerializableDatabase(this.keePassFile);
        streamFormat.save((SerializableDatabase)simpleSerializableDatabase, credentials, outputStream);
        this.setDirty(false);
    }

    public SimpleGroup getRootGroup() {
        return this.keePassFile.root.getGroup();
    }

    public SimpleGroup newGroup() {
        return SimpleGroup.createGroup(this);
    }

    public SimpleEntry newEntry() {
        return SimpleEntry.createEntry(this);
    }

    public SimpleIcon newIcon() {
        return new SimpleIcon();
    }

    public SimpleIcon newIcon(Integer integer) {
        SimpleIcon ic = this.newIcon();
        ic.setIndex(integer);
        return ic;
    }

    public boolean isRecycleBinEnabled() {
        return this.keePassFile.meta.recycleBinEnabled;
    }

    public void enableRecycleBin(boolean enable) {
        this.keePassFile.meta.recycleBinEnabled = enable;
    }

    public SimpleGroup getRecycleBin() {
        UUID recycleBinUuid = this.keePassFile.meta.recycleBinUUID;
        SimpleGroup g = (SimpleGroup)this.findGroup(recycleBinUuid);
        if (g == null && this.isRecycleBinEnabled()) {
            g = (SimpleGroup)this.newGroup("Recycle Bin");
            this.getRootGroup().addGroup(g);
            this.keePassFile.meta.recycleBinUUID = g.getUuid();
            this.keePassFile.meta.recycleBinChanged = new Date();
        }
        return g;
    }

    public String getName() {
        return this.keePassFile.meta.databaseName;
    }

    public void setName(String s) {
        this.keePassFile.meta.databaseName = s;
        this.keePassFile.meta.databaseNameChanged = new Date();
        this.setDirty(true);
    }

    public String getDescription() {
        return this.keePassFile.meta.databaseDescription;
    }

    public void setDescription(String s) {
        this.keePassFile.meta.databaseDescription = s;
        this.keePassFile.meta.databaseDescriptionChanged = new Date();
        this.setDirty(true);
    }

    public boolean shouldProtect(String s) {
        return this.keePassFile.meta.memoryProtection.shouldProtect(s);
    }

    public List<KeePassFile.Binary> getBinaries() {
        return this.keePassFile.getBinaries();
    }

    public void addBinary(byte[] bytes, int index) {
        SimpleSerializableDatabase.addBinary(this.keePassFile, index, bytes);
    }

    public StreamFormat<?> getStreamFormat() {
        return this.streamFormat;
    }
}

