/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.linguafranca.pwdb.SerializableDatabase;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.simple.SimpleDatabase;
import org.linguafranca.pwdb.kdbx.simple.SimpleEntry;
import org.linguafranca.pwdb.kdbx.simple.SimpleGroup;
import org.linguafranca.pwdb.kdbx.simple.converter.EmptyStringConverter;
import org.linguafranca.pwdb.kdbx.simple.converter.ValueConverter;
import org.linguafranca.pwdb.kdbx.simple.model.EntryClasses;
import org.linguafranca.pwdb.kdbx.simple.model.KeePassFile;
import org.linguafranca.pwdb.security.StreamEncryptor;
import org.simpleframework.xml.Serializer;
import org.simpleframework.xml.convert.AnnotationStrategy;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.convert.Registry;
import org.simpleframework.xml.convert.RegistryStrategy;
import org.simpleframework.xml.core.Persister;
import org.simpleframework.xml.strategy.Strategy;

public class SimpleSerializableDatabase
implements SerializableDatabase {
    public KeePassFile keePassFile;
    private StreamEncryptor encryption;

    public SimpleSerializableDatabase() {
    }

    public SimpleSerializableDatabase(KeePassFile keePassFile) {
        this.keePassFile = keePassFile;
    }

    static KeePassFile createEmptyDatabase() {
        InputStream inputStream = SimpleDatabase.class.getClassLoader().getResourceAsStream("base.kdbx.xml");
        try {
            return (KeePassFile)SimpleSerializableDatabase.getSerializer((StreamEncryptor)new StreamEncryptor.None()).read(KeePassFile.class, inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public SimpleSerializableDatabase load(InputStream inputStream) {
        try {
            this.keePassFile = (KeePassFile)SimpleSerializableDatabase.getSerializer(this.encryption).read(KeePassFile.class, inputStream);
            SimpleSerializableDatabase.fixUp(this.keePassFile.root.group);
            return this;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        SimpleSerializableDatabase.prepareForSave(this.keePassFile.root.group);
        try {
            SimpleSerializableDatabase.getSerializer(this.encryption).write((Object)this.keePassFile, outputStream);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Serializer getSerializer(StreamEncryptor encryption) {
        Registry registry = new Registry();
        try {
            registry.bind(String.class, EmptyStringConverter.class);
            registry.bind(EntryClasses.StringProperty.Value.class, (Converter)new ValueConverter(encryption));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        AnnotationStrategy strategy = new AnnotationStrategy((Strategy)new RegistryStrategy(registry));
        return new Persister((Strategy)strategy);
    }

    private static void prepareForSave(SimpleGroup parent) {
        for (SimpleGroup group : parent.group) {
            SimpleSerializableDatabase.prepareForSave(group);
        }
        for (SimpleEntry entry : parent.entry) {
            for (EntryClasses.StringProperty property : entry.string) {
                boolean shouldProtect = parent.database.shouldProtect(property.getKey());
                property.getValue().setProtectOnOutput(shouldProtect || property.getValue().getProtectOnOutput());
            }
            if (!Objects.nonNull(entry.history)) continue;
            for (SimpleEntry entry2 : entry.history) {
                for (EntryClasses.StringProperty property : entry2.string) {
                    boolean shouldProtect = parent.database.shouldProtect(property.getKey());
                    property.getValue().setProtectOnOutput(shouldProtect || property.getValue().getProtectOnOutput());
                }
            }
        }
    }

    static void fixUp(SimpleGroup parent) {
        for (SimpleGroup group : parent.group) {
            group.parent = parent;
            group.database = parent.database;
            SimpleSerializableDatabase.fixUp(group);
        }
        for (SimpleEntry entry : parent.entry) {
            entry.database = parent.database;
            entry.parent = parent;
        }
    }

    public StreamEncryptor getEncryption() {
        return this.encryption;
    }

    public void setEncryption(StreamEncryptor encryption) {
        this.encryption = encryption;
    }

    public byte[] getHeaderHash() {
        return this.keePassFile.meta.headerHash.getContent();
    }

    public void setHeaderHash(byte[] hash) {
        this.keePassFile.meta.headerHash = new KeePassFile.ByteArray(hash);
    }

    public void addBinary(int index, byte[] value) {
        SimpleSerializableDatabase.addBinary(this.keePassFile, index, value);
    }

    public byte[] getBinary(int index) {
        KeePassFile.Binary binary = this.keePassFile.getBinaries().get(index);
        String value = binary.getValue();
        return Helpers.decodeBase64Content((byte[])value.getBytes(), (boolean)binary.getCompressed());
    }

    public int getBinaryCount() {
        if (Objects.isNull(this.keePassFile.getBinaries())) {
            return 0;
        }
        return this.keePassFile.getBinaries().size();
    }

    public static void addBinary(KeePassFile keePassFile, int index, byte[] value) {
        KeePassFile.Binary newBin = new KeePassFile.Binary();
        newBin.setId(index);
        newBin.setValue(Helpers.encodeBase64Content((byte[])value, (boolean)true));
        newBin.setCompressed(true);
        if (keePassFile.getBinaries() == null) {
            keePassFile.createBinaries();
        }
        keePassFile.getBinaries().add(newBin);
    }

    public KeePassFile getKeePassFile() {
        return this.keePassFile;
    }

    public void setKeePassFile(KeePassFile keypassFile) {
        this.keePassFile = keypassFile;
    }
}

