/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.simple.converter;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.linguafranca.pwdb.kdbx.simple.model.EntryClasses;
import org.linguafranca.pwdb.security.StreamEncryptor;
import org.simpleframework.xml.convert.Converter;
import org.simpleframework.xml.stream.InputNode;
import org.simpleframework.xml.stream.OutputNode;

public class ValueConverter
implements Converter<EntryClasses.StringProperty.Value> {
    private final StreamEncryptor encryption;

    public ValueConverter(StreamEncryptor encryption) {
        this.encryption = encryption;
    }

    public EntryClasses.StringProperty.Value read(InputNode node) throws Exception {
        EntryClasses.StringProperty.Value value = new EntryClasses.StringProperty.Value();
        if (Objects.nonNull(node.getAttribute("Protected")) && node.getAttribute("Protected").getValue().equals("True")) {
            byte[] encrypted = new byte[]{};
            String text = node.getValue();
            if (Objects.nonNull(text)) {
                encrypted = Base64.decodeBase64((byte[])text.getBytes());
            }
            String decrypted = new String(this.encryption.decrypt(encrypted), StandardCharsets.UTF_8);
            value.setText(decrypted);
            value.setProtected(null);
            value.setProtectOnOutput(true);
        } else {
            value.setProtectOnOutput(false);
            value.setText(node.getValue());
        }
        return value;
    }

    public void write(OutputNode node, EntryClasses.StringProperty.Value value) throws Exception {
        if (value.getProtectOnOutput()) {
            byte[] encrypted = this.encryption.encrypt(value.getText().getBytes(StandardCharsets.UTF_8));
            byte[] base64Encoded = Base64.encodeBase64((byte[])encrypted);
            node.setValue(new String(base64Encoded));
            node.getAttributes().put("Protected", "True");
        } else {
            node.setValue(value.getText());
        }
    }
}

