/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.base;

import java.util.List;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.Group;
import org.linguafranca.pwdb.Icon;
import org.linguafranca.pwdb.Visitor;

public abstract class AbstractDatabase<D extends Database<D, G, E, I>, G extends Group<D, G, E, I>, E extends Entry<D, G, E, I>, I extends Icon>
implements Database<D, G, E, I> {
    private boolean isDirty;

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.startVisit((Group)this.getRootGroup());
        this.visit(this.getRootGroup(), visitor);
        visitor.endVisit((Group)this.getRootGroup());
    }

    @Override
    public void visit(G group, Visitor visitor) {
        if (visitor.isEntriesFirst()) {
            for (Entry entry : group.getEntries()) {
                visitor.visit(entry);
            }
        }
        for (Group g : group.getGroups()) {
            visitor.startVisit(g);
            this.visit(g, visitor);
            visitor.endVisit(g);
        }
        if (!visitor.isEntriesFirst()) {
            for (Entry entry : group.getEntries()) {
                visitor.visit(entry);
            }
        }
    }

    @Override
    public List<? extends E> findEntries(Entry.Matcher matcher) {
        return this.getRootGroup().findEntries(matcher, true);
    }

    @Override
    public List<? extends E> findEntries(String find) {
        return this.getRootGroup().findEntries(find, true);
    }

    @Override
    public G newGroup(String name) {
        Object result = this.newGroup();
        result.setName(name);
        return result;
    }

    @Override
    public G newGroup(Group group) {
        Object result = this.newGroup();
        result.setName(group.getName());
        result.setIcon(this.newIcon(group.getIcon().getIndex()));
        return result;
    }

    @Override
    public E newEntry(String title) {
        Object result = this.newEntry();
        result.setTitle(title);
        return result;
    }

    @Override
    public E newEntry(Entry<?, ?, ?, ?> entry) {
        Object result = this.newEntry();
        for (String propertyName : entry.getPropertyNames()) {
            try {
                result.setProperty(propertyName, entry.getProperty(propertyName));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        try {
            for (String propertyName : entry.getBinaryPropertyNames()) {
                try {
                    result.setBinaryProperty(propertyName, entry.getBinaryProperty(propertyName));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        result.setIcon(this.newIcon(entry.getIcon().getIndex()));
        return result;
    }
}

