/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.base;

import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.Group;
import org.linguafranca.pwdb.Icon;
import org.linguafranca.pwdb.PropertyValue;

public abstract class AbstractEntry<D extends Database<D, G, E, I>, G extends Group<D, G, E, I>, E extends Entry<D, G, E, I>, I extends Icon>
implements Entry<D, G, E, I> {
    @Override
    public boolean matchTitle(String text) {
        return this.getTitle() != null && this.getTitle().toLowerCase().contains(text.toLowerCase());
    }

    @Override
    public boolean matchNotes(String text) {
        return this.getNotes() != null && this.getNotes().toLowerCase().contains(text.toLowerCase());
    }

    @Override
    public boolean matchUsername(String text) {
        return this.getUsername() != null && this.getUsername().toLowerCase().contains(text.toLowerCase());
    }

    @Override
    public boolean matchUrl(String text) {
        return this.getUrl() != null && this.getUrl().toLowerCase().contains(text.toLowerCase());
    }

    @Override
    public boolean match(String text) {
        return this.matchTitle(text) || this.matchNotes(text) || this.matchUrl(text) || this.matchUsername(text);
    }

    @Override
    public boolean match(Entry.Matcher matcher) {
        return matcher.matches(this);
    }

    @Override
    public String getPath() {
        Object parent = this.getParent();
        String result = "";
        if (parent != null) {
            result = parent.getPath();
        }
        return result + this.getTitle();
    }

    public String toString() {
        return this.getPath();
    }

    @Override
    public String getUsername() {
        return this.getProperty("UserName");
    }

    @Override
    public void setUsername(String username) {
        this.setProperty("UserName", username);
        this.touch();
    }

    @Override
    public String getPassword() {
        return this.getProperty("Password");
    }

    @Override
    public void setPassword(String pass) {
        this.setProperty("Password", pass);
        this.touch();
    }

    @Override
    public String getUrl() {
        return this.getProperty("URL");
    }

    @Override
    public void setUrl(String url) {
        this.setProperty("URL", url);
        this.touch();
    }

    @Override
    public String getTitle() {
        return this.getProperty("Title");
    }

    @Override
    public void setTitle(String title) {
        this.setProperty("Title", title);
        this.touch();
    }

    @Override
    public String getNotes() {
        return this.getProperty("Notes");
    }

    @Override
    public void setNotes(String notes) {
        this.setProperty("Notes", notes);
        this.touch();
    }

    @Override
    public PropertyValue getPropertyValue(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPropertyValue(String name, PropertyValue value) {
        throw new UnsupportedOperationException();
    }

    protected abstract void touch();
}

