/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.security;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.ChaCha7539Engine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.io.CipherOutputStream;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.linguafranca.pwdb.security.CipherAlgorithm;

public class ChaCha
implements CipherAlgorithm {
    private static final UUID CHA_CHA_20_CIPHER = UUID.fromString("d6038a2b-8b6f-4cb5-a524-339a31dbb59a");
    private static final String name = "CHA_CHA_20";
    private static final ChaCha instance = new ChaCha();

    private ChaCha() {
    }

    public static ChaCha getInstance() {
        return instance;
    }

    @Override
    public UUID getCipherUuid() {
        return CHA_CHA_20_CIPHER;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public InputStream getDecryptedInputStream(InputStream encryptedInputStream, byte[] key, byte[] iv) {
        ParametersWithIV keyAndIV = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
        ChaCha7539Engine cipher = new ChaCha7539Engine();
        cipher.init(false, (CipherParameters)keyAndIV);
        return new CipherInputStream(encryptedInputStream, (StreamCipher)cipher);
    }

    @Override
    public OutputStream getEncryptedOutputStream(OutputStream decryptedOutputStream, byte[] key, byte[] iv) {
        ParametersWithIV keyAndIV = new ParametersWithIV((CipherParameters)new KeyParameter(key), iv);
        ChaCha7539Engine cipher = new ChaCha7539Engine();
        cipher.init(true, (CipherParameters)keyAndIV);
        return new CipherOutputStream(decryptedOutputStream, (StreamCipher)cipher);
    }
}

