/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;

public interface PropertyValue {
    public CharSequence getValue();

    public char[] getValueAsChars();

    public byte[] getValueAsBytes();

    public boolean isProtected();

    public String getValueAsString();

    public static byte[] charsToBytes(char[] value) {
        CharBuffer cb = CharBuffer.wrap(value);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(cb);
        byte[] result = new byte[bb.limit()];
        bb.get(result);
        return result;
    }

    public static char[] bytesToChars(byte[] value) {
        ByteBuffer bb = ByteBuffer.wrap(value);
        CharBuffer cb = Charsets.UTF_8.decode(bb);
        char[] chars = new char[cb.limit()];
        cb.get(chars);
        return chars;
    }

    public static byte[] charSequenceToBytes(CharSequence charSequence) {
        CharBuffer cb = CharBuffer.wrap(charSequence);
        ByteBuffer bb = StandardCharsets.UTF_8.encode(cb);
        byte[] result = new byte[bb.limit()];
        bb.get(result);
        return result;
    }

    public static CharSequence bytesToCharSequence(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        return StandardCharsets.UTF_8.decode(bb);
    }

    public static class SealedStore
    implements PropertyValue {
        static SecureRandom secureRandom = new SecureRandom();
        private final SealedObject sealedObject;
        private final ByteBuffer buffer;
        private static final Factory<SealedStore> factory = new Factory<SealedStore>(){

            @Override
            public SealedStore of(CharSequence aCharSequence) {
                return new SealedStore(aCharSequence);
            }

            @Override
            public SealedStore of(char[] value) {
                return new SealedStore(value);
            }

            @Override
            public SealedStore of(byte[] value) {
                return new SealedStore(value);
            }
        };

        /*
         * Exception decompiling
         */
        private ByteBuffer storeKey(SecretKey key) throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private SecretKey retrieveKey(ByteBuffer buffer) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private byte[] getBytes() {
            try {
                SecretKey key = this.retrieveKey(this.buffer);
                byte[] cs = (byte[])this.sealedObject.getObject(key);
                key.destroy();
                return cs;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static Factory<SealedStore> getFactory() {
            return factory;
        }

        public SealedStore(byte[] bytes) {
            try {
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                AESKey key = new AESKey();
                cipher.init(1, key);
                this.buffer = this.storeKey(key);
                key.destroy();
                this.sealedObject = new SealedObject((Serializable)bytes, cipher);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public SealedStore(char[] chars) {
            this(PropertyValue.charsToBytes(chars));
        }

        public SealedStore(CharSequence charSequence) {
            this(PropertyValue.charSequenceToBytes(charSequence));
        }

        @Override
        public String getValueAsString() {
            return new String(this.getBytes());
        }

        @Override
        public char[] getValueAsChars() {
            return PropertyValue.bytesToChars(this.getBytes());
        }

        @Override
        public byte[] getValueAsBytes() {
            byte[] result = this.getBytes();
            return Arrays.copyOf(result, result.length);
        }

        @Override
        public CharSequence getValue() {
            return PropertyValue.bytesToCharSequence(this.getBytes());
        }

        @Override
        public boolean isProtected() {
            return true;
        }

        private static class AESKey
        implements SecretKey {
            private boolean destroyed = false;
            private final byte[] key = new byte[16];
            final String algorithm = "AES";

            private AESKey() {
                secureRandom.nextBytes(this.key);
            }

            @Override
            public void destroy() {
                Arrays.fill(this.key, (byte)0);
                this.destroyed = true;
            }

            @Override
            public boolean isDestroyed() {
                return this.destroyed;
            }

            @Override
            public String getAlgorithm() {
                return this.algorithm;
            }

            @Override
            public String getFormat() {
                return "RAW";
            }

            @Override
            public byte[] getEncoded() {
                return (byte[])this.key.clone();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof AESKey)) {
                    return false;
                }
                AESKey aesKey = (AESKey)o;
                return this.destroyed == aesKey.destroyed && Arrays.equals(this.key, aesKey.key);
            }

            public int hashCode() {
                int result = Objects.hash(this.destroyed, "AES");
                result = 31 * result + Arrays.hashCode(this.key);
                return result;
            }

            public void writeObject(ObjectOutputStream os) throws IOException {
                if (this.destroyed) {
                    throw new IllegalStateException("Can't serialize a destroyed key");
                }
                os.defaultWriteObject();
            }
        }
    }

    public static class BytesStore
    implements PropertyValue,
    Serializable {
        private final byte[] value;
        private static final Factory<BytesStore> factory = new Factory<BytesStore>(){

            @Override
            public BytesStore of(CharSequence aCharSequence) {
                return new BytesStore(aCharSequence);
            }

            @Override
            public BytesStore of(char[] value) {
                return new BytesStore(value);
            }

            @Override
            public BytesStore of(byte[] value) {
                return new BytesStore(value);
            }
        };

        public static Factory<BytesStore> getFactory() {
            return factory;
        }

        public BytesStore(CharSequence aString) {
            this.value = PropertyValue.charSequenceToBytes(aString);
        }

        public BytesStore(char[] value) {
            this.value = PropertyValue.charsToBytes(value);
        }

        public BytesStore(byte[] value) {
            this.value = Arrays.copyOf(value, value.length);
        }

        @Override
        public String getValueAsString() {
            return new String(this.value);
        }

        @Override
        public CharSequence getValue() {
            ByteBuffer bb = ByteBuffer.wrap(this.value);
            return Charsets.UTF_8.decode(bb);
        }

        @Override
        public char[] getValueAsChars() {
            return PropertyValue.bytesToChars(this.value);
        }

        @Override
        public byte[] getValueAsBytes() {
            return Arrays.copyOf(this.value, this.value.length);
        }

        @Override
        public boolean isProtected() {
            return false;
        }
    }

    public static class StringStore
    implements PropertyValue {
        private final String value;
        private static final Factory<StringStore> factory = new Factory<StringStore>(){

            @Override
            public StringStore of(CharSequence aCharSequence) {
                return new StringStore(aCharSequence);
            }

            @Override
            public StringStore of(char[] value) {
                return new StringStore(value);
            }

            @Override
            public StringStore of(byte[] value) {
                return new StringStore(value);
            }
        };

        public static Factory<StringStore> getFactory() {
            return factory;
        }

        public StringStore(CharSequence aCharSequence) {
            this.value = String.valueOf(aCharSequence);
        }

        public StringStore(char[] value) {
            this.value = String.valueOf(value);
        }

        public StringStore(byte[] value) {
            this.value = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(value)).toString();
        }

        @Override
        public String getValueAsString() {
            return this.value;
        }

        @Override
        public char[] getValueAsChars() {
            return this.value.toCharArray();
        }

        @Override
        public byte[] getValueAsBytes() {
            return this.value.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public CharSequence getValue() {
            return this.value;
        }

        @Override
        public boolean isProtected() {
            return false;
        }
    }

    public static interface Strategy {
        public List<String> getProtectedProperties();

        public Factory<? extends PropertyValue> newProtected();

        public Factory<? extends PropertyValue> newUnprotected();

        default public Factory<? extends PropertyValue> getFactoryFor(String propertyName) {
            return this.getProtectedProperties().contains(propertyName) ? this.newProtected() : this.newUnprotected();
        }

        public static class Default
        implements Strategy {
            @Override
            public List<String> getProtectedProperties() {
                return new ArrayList<String>(Arrays.asList("Password"));
            }

            @Override
            public Factory<? extends PropertyValue> newProtected() {
                return SealedStore.getFactory();
            }

            @Override
            public Factory<? extends PropertyValue> newUnprotected() {
                return BytesStore.getFactory();
            }
        }
    }

    public static interface Factory<P extends PropertyValue> {
        public P of(CharSequence var1);

        public P of(char[] var1);

        public P of(byte[] var1);
    }
}

