/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb;

import java.io.PrintStream;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.Group;
import org.linguafranca.pwdb.Icon;

public interface Visitor<D extends Database<D, G, E, I>, G extends Group<D, G, E, I>, E extends Entry<D, G, E, I>, I extends Icon> {
    public void startVisit(G var1);

    public void endVisit(G var1);

    public void visit(E var1);

    public boolean isEntriesFirst();

    public static class Print<D extends Database<D, G, E, I>, G extends Group<D, G, E, I>, E extends Entry<D, G, E, I>, I extends Icon>
    extends Default<D, G, E, I> {
        private final PrintStream printStream;

        public Print() {
            this(System.out);
        }

        public Print(PrintStream out) {
            this.printStream = out;
        }

        @Override
        public void startVisit(G group) {
            this.printStream.println(group.toString());
        }

        @Override
        public void visit(E entry) {
            this.printStream.println(entry.toString());
        }
    }

    public static abstract class Default<D extends Database<D, G, E, I>, G extends Group<D, G, E, I>, E extends Entry<D, G, E, I>, I extends Icon>
    implements Visitor<D, G, E, I> {
        @Override
        public void startVisit(G group) {
        }

        @Override
        public void endVisit(G group) {
        }

        @Override
        public void visit(E entry) {
        }

        @Override
        public boolean isEntriesFirst() {
            return true;
        }
    }
}

