/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.security;

import java.security.MessageDigest;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.ChaCha7539Engine;
import org.bouncycastle.crypto.engines.Salsa20Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.encoders.Hex;
import org.linguafranca.pwdb.security.Encryption;

public interface StreamEncryptor {
    public byte[] getKey();

    public byte[] decrypt(byte[] var1);

    public byte[] encrypt(byte[] var1);

    public static class Default
    implements StreamEncryptor {
        private final StreamCipher cipher;
        private final byte[] key;

        public void initialize(byte[] key, byte[] iv) {
            KeyParameter keyParameter = new KeyParameter(key);
            ParametersWithIV ivParameter = new ParametersWithIV((CipherParameters)keyParameter, iv);
            this.cipher.init(true, (CipherParameters)ivParameter);
        }

        public Default(StreamCipher cipher, byte[] key) {
            this.key = key;
            this.cipher = cipher;
        }

        @Override
        public byte[] getKey() {
            return this.key;
        }

        @Override
        public byte[] decrypt(byte[] encryptedText) {
            byte[] output = new byte[encryptedText.length];
            this.cipher.processBytes(encryptedText, 0, encryptedText.length, output, 0);
            return output;
        }

        @Override
        public byte[] encrypt(byte[] decryptedText) {
            byte[] output = new byte[decryptedText.length];
            this.cipher.processBytes(decryptedText, 0, decryptedText.length, output, 0);
            return output;
        }
    }

    public static class Salsa20
    extends Default {
        private static final byte[] SALSA20_IV = Hex.decode((byte[])"E830094B97205D2A".getBytes());

        public Salsa20(byte[] key) {
            super((StreamCipher)new Salsa20Engine(), key);
            MessageDigest md = Encryption.getSha256MessageDigestInstance();
            this.initialize(md.digest(key), SALSA20_IV);
        }
    }

    public static class ChaCha20
    extends Default {
        public ChaCha20(byte[] key) {
            super((StreamCipher)new ChaCha7539Engine(), key);
            MessageDigest md = Encryption.getSha512MessageDigestInstance();
            md.update(key);
            byte[] digest = md.digest();
            byte[] keyDigest = new byte[32];
            byte[] iv = new byte[12];
            System.arraycopy(digest, 0, keyDigest, 0, keyDigest.length);
            System.arraycopy(digest, 32, iv, 0, iv.length);
            this.initialize(keyDigest, iv);
        }
    }

    public static class None
    implements StreamEncryptor {
        @Override
        public byte[] getKey() {
            return new byte[0];
        }

        @Override
        public byte[] decrypt(byte[] encryptedText) {
            return encryptedText;
        }

        @Override
        public byte[] encrypt(byte[] decryptedText) {
            return decryptedText;
        }
    }
}

