/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.glu.utils.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.linkedin.util.lang.LangUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparableTreeSet<T extends Comparable<T>>
extends TreeSet<T>
implements Comparable<ComparableTreeSet<T>> {
    public ComparableTreeSet() {
    }

    public ComparableTreeSet(Comparator<? super T> comparator) {
        super(comparator);
    }

    public ComparableTreeSet(Collection<? extends T> ts) {
        super(ts);
    }

    public ComparableTreeSet(SortedSet<T> ts) {
        super(ts);
    }

    @Override
    public int compareTo(ComparableTreeSet<T> set) {
        int res = LangUtils.compare((int)this.size(), (int)set.size());
        if (res != 0) {
            return res;
        }
        Iterator thisValues = this.iterator();
        Iterator otherValues = set.iterator();
        while (thisValues.hasNext()) {
            res = LangUtils.compare((Comparable)((Comparable)thisValues.next()), (Comparable)((Comparable)otherValues.next()));
            if (res == 0) continue;
            return res;
        }
        return 0;
    }
}

