/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.glu.utils.tags;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagIndex {
    private final Map<String, Set<String>> _indexByTag = new HashMap<String, Set<String>>();
    private final Map<String, Set<String>> _indexByKey = new HashMap<String, Set<String>>();

    public TagIndex() {
    }

    public TagIndex(TagIndex other) {
        for (Map.Entry<String, Set<String>> entry : other._indexByKey.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    public void add(String key, Set<String> tags) {
        this._indexByKey.put(key, tags);
        for (String tag : tags) {
            Set<String> keys = this._indexByTag.get(tag);
            if (keys == null) {
                keys = new HashSet<String>();
                this._indexByTag.put(tag, keys);
            }
            keys.add(key);
        }
    }

    public void remove(String key) {
        Set<String> tags = this._indexByKey.remove(key);
        if (tags != null) {
            for (String tag : tags) {
                Set<String> keys = this._indexByTag.get(tag);
                keys.remove(key);
                if (!keys.isEmpty()) continue;
                this._indexByTag.remove(tag);
            }
        }
    }

    public Set<String> getKeys() {
        return this._indexByKey.keySet();
    }

    public Set<String> getTags() {
        return this._indexByTag.keySet();
    }

    public Set<String> getKeys(String tag) {
        return this._indexByTag.get(tag);
    }

    public Set<String> getTags(String key) {
        return this._indexByKey.get(key);
    }
}

