/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.glu.utils.tags;

import java.util.Collection;
import java.util.Set;
import org.linkedin.glu.utils.tags.Taggeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaggeableSetImpl
implements Taggeable {
    private volatile Set<String> _tags;

    public TaggeableSetImpl() {
        this._tags = this.createEmptySet();
    }

    protected abstract Set<String> createEmptySet();

    protected abstract Set<String> createSet(Collection<String> var1);

    @Override
    public int getTagsCount() {
        return this._tags.size();
    }

    @Override
    public boolean hasTags() {
        return !this._tags.isEmpty();
    }

    public TaggeableSetImpl(Collection<String> tags) {
        this._tags = this.createSet(tags);
    }

    @Override
    public Set<String> getTags() {
        return this._tags;
    }

    @Override
    public boolean hasTag(String tag) {
        return this._tags.contains(tag);
    }

    @Override
    public boolean hasAllTags(Collection<String> tags) {
        return this._tags.containsAll(tags);
    }

    @Override
    public boolean hasAnyTag(Collection<String> tags) {
        Set<String> localTags = this._tags;
        for (String tag : tags) {
            if (!localTags.contains(tag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getCommonTags(Collection<String> tags) {
        Set<String> localTags = this._tags;
        Set<String> res = this.createEmptySet();
        for (String tag : tags) {
            if (!localTags.contains(tag)) continue;
            res.add(tag);
        }
        return res;
    }

    @Override
    public Set<String> getMissingTags(Collection<String> tags) {
        Set<String> localTags = this._tags;
        Set<String> res = this.createEmptySet();
        for (String tag : tags) {
            if (localTags.contains(tag)) continue;
            res.add(tag);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTag(String tag) {
        TaggeableSetImpl taggeableSetImpl = this;
        synchronized (taggeableSetImpl) {
            if (this._tags.contains(tag)) {
                return false;
            }
            Set<String> newTags = this.createSet(this._tags);
            newTags.add(tag);
            this._tags = newTags;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> addTags(Collection<String> tags) {
        Set<String> res = this.createEmptySet();
        TaggeableSetImpl taggeableSetImpl = this;
        synchronized (taggeableSetImpl) {
            Set<String> newTags = this.createSet(this._tags);
            for (String tag : tags) {
                if (newTags.add(tag)) continue;
                res.add(tag);
            }
            this._tags = newTags;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTag(String tag) {
        TaggeableSetImpl taggeableSetImpl = this;
        synchronized (taggeableSetImpl) {
            if (!this._tags.contains(tag)) {
                return false;
            }
            Set<String> newTags = this.createSet(this._tags);
            newTags.remove(tag);
            this._tags = newTags;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> removeTags(Collection<String> tags) {
        Set<String> res = this.createEmptySet();
        TaggeableSetImpl taggeableSetImpl = this;
        synchronized (taggeableSetImpl) {
            Set<String> newTags = this.createSet(this._tags);
            for (String tag : tags) {
                if (newTags.remove(tag)) continue;
                res.add(tag);
            }
            this._tags = newTags;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTags(Collection<String> tags) {
        TaggeableSetImpl taggeableSetImpl = this;
        synchronized (taggeableSetImpl) {
            this._tags = this.createSet(tags);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TaggeableSetImpl)) {
            return false;
        }
        TaggeableSetImpl taggeable = (TaggeableSetImpl)o;
        return ((Object)this._tags).equals(taggeable._tags);
    }

    public int hashCode() {
        return ((Object)this._tags).hashCode();
    }
}

