/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.glu.utils.tags;

import java.util.Collection;
import org.linkedin.glu.utils.tags.ReadOnlyTaggeable;
import org.linkedin.util.text.StringSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsSerializer {
    public static final TagsSerializer INSTANCE = new TagsSerializer();
    public static final String TAGS_SEPARATOR = ";";
    public static final StringSplitter STRING_SPLITTER = new StringSplitter(';');

    public static TagsSerializer instance() {
        return INSTANCE;
    }

    public String serialize(ReadOnlyTaggeable tags) {
        if (tags == null) {
            return null;
        }
        return this.serialize(tags.getTags());
    }

    public String serialize(Collection<String> tags) {
        if (tags == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String tag : tags) {
            if (sb.length() > 0) {
                sb.append(TAGS_SEPARATOR);
            }
            sb.append(tag);
        }
        return sb.toString();
    }

    public Collection<String> deserialize(String tags) {
        return STRING_SPLITTER.splitAsSet(tags);
    }
}

