/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.core.vaadin.component.tablayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventBus;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.tabs.Tab;
import com.vaadin.flow.component.tabs.Tabs;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.shared.Registration;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.linkki.core.vaadin.component.tablayout.AfterTabSelectedObserver;
import org.linkki.util.LazyReference;

public class LinkkiTabSheet {
    private final Tab tab;
    private final LazyReference<Component> contentReference;
    private final BooleanSupplier visibilitySupplier;
    @CheckForNull
    private ComponentEventBus eventBus;

    LinkkiTabSheet(String id, String caption, @CheckForNull Component captionComponent, String description, Supplier<Component> contentSupplier, BooleanSupplier visibilitySupplier, List<ComponentEventListener<TabSheetSelectionChangeEvent>> onSelectionListener) {
        this.tab = new Tab(Objects.requireNonNull(caption, "caption must not be null"));
        this.tab.setId(Objects.requireNonNull(id, "id must not be null"));
        this.tab.getElement().setAttribute("title", description);
        this.contentReference = new LazyReference(Objects.requireNonNull(contentSupplier, "contentSupplier must not be null"));
        onSelectionListener.forEach(this::addTabSelectionChangeListener);
        this.visibilitySupplier = Objects.requireNonNull(visibilitySupplier, "visibilitySupplier must not be null");
        this.tab.setVisible(visibilitySupplier.getAsBoolean());
        if (captionComponent != null) {
            this.tab.add(new Component[]{captionComponent});
        }
    }

    public Tab getTab() {
        return this.tab;
    }

    public Component getContent() {
        return (Component)this.contentReference.get();
    }

    boolean isContentLoaded() {
        return this.contentReference.isValuePresent();
    }

    protected boolean isVisible() {
        return this.visibilitySupplier.getAsBoolean();
    }

    public String getId() {
        return (String)this.getTab().getId().orElseThrow();
    }

    public String getDescription() {
        return this.getTab().getElement().getAttribute("title");
    }

    protected void select(HasComponents contentWrapper, Tabs.SelectedChangeEvent e) {
        Component content = this.getContent();
        if (!content.getParent().isPresent()) {
            contentWrapper.add(new Component[]{content});
        }
        content.setVisible(true);
        TabSheetSelectionChangeEvent tabSelectedEvent = new TabSheetSelectionChangeEvent(e, this);
        this.fireTabSheetSelectionChangeEvent(tabSelectedEvent);
        this.callAfterSelectionObserver(tabSelectedEvent);
    }

    protected ComponentEventBus getEventBus() {
        if (this.eventBus == null) {
            this.eventBus = new ComponentEventBus((Component)this.tab);
        }
        return this.eventBus;
    }

    public Registration addTabSelectionChangeListener(ComponentEventListener<TabSheetSelectionChangeEvent> listener) {
        return this.getEventBus().addListener(TabSheetSelectionChangeEvent.class, listener);
    }

    private void fireTabSheetSelectionChangeEvent(TabSheetSelectionChangeEvent e) {
        this.getEventBus().fireEvent((ComponentEvent)e);
    }

    private void callAfterSelectionObserver(TabSheetSelectionChangeEvent event) {
        Component content = event.getTabSheet().getContent();
        ArrayList descendants = new ArrayList();
        EventUtil.inspectHierarchy((Element)content.getElement(), descendants, e -> e.getComponent().filter(c -> !(c instanceof Text)).map(Component::isVisible).orElse(false));
        EventUtil.getImplementingComponents(descendants.stream(), AfterTabSelectedObserver.class).forEach(o -> o.afterTabSelected(event));
    }

    protected void unselect() {
        this.getContent().setVisible(false);
    }

    public String toString() {
        return String.format("%s [ID: %s])", this.getClass().getSimpleName(), this.getId());
    }

    public static LinkkiTabSheetBuilder builder(String id) {
        return new LinkkiTabSheetBuilder(id);
    }

    public static class TabSheetSelectionChangeEvent
    extends Tabs.SelectedChangeEvent {
        private static final long serialVersionUID = 1L;
        private final LinkkiTabSheet tabSheet;

        public TabSheetSelectionChangeEvent(Tabs.SelectedChangeEvent wrappedEvent, LinkkiTabSheet tabSheet) {
            super((Tabs)wrappedEvent.getSource(), wrappedEvent.getPreviousTab(), wrappedEvent.isFromClient());
            this.tabSheet = tabSheet;
        }

        public LinkkiTabSheet getTabSheet() {
            return this.tabSheet;
        }
    }

    public static class LinkkiTabSheetBuilder {
        private final String id;
        @CheckForNull
        private String caption;
        @CheckForNull
        private Component captionComponent;
        @CheckForNull
        private String description;
        @CheckForNull
        private Supplier<Component> contentSupplier;
        private BooleanSupplier visibilitySupplier = () -> true;
        private final List<ComponentEventListener<TabSheetSelectionChangeEvent>> selectionChangeListeners = new ArrayList<ComponentEventListener<TabSheetSelectionChangeEvent>>();

        private LinkkiTabSheetBuilder(String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
        }

        public LinkkiTabSheetBuilder caption(Component newCaption) {
            this.captionComponent = Objects.requireNonNull(newCaption, "newCaption must not be null");
            this.caption = null;
            return this;
        }

        public LinkkiTabSheetBuilder caption(String newCaption) {
            this.caption = Objects.requireNonNull(newCaption, "newCaption must not be null");
            this.captionComponent = null;
            return this;
        }

        public LinkkiTabSheetBuilder description(String newDescription) {
            this.description = Objects.requireNonNull(newDescription, "newDescription must not be null");
            return this;
        }

        public LinkkiTabSheetBuilder content(Supplier<Component> newContentSupplier) {
            this.contentSupplier = Objects.requireNonNull(newContentSupplier, "newContentSupplier must not be null");
            return this;
        }

        public LinkkiTabSheetBuilder visibleWhen(BooleanSupplier newVisibilitySupplier) {
            this.visibilitySupplier = Objects.requireNonNull(newVisibilitySupplier, "newVisibilitySupplier must not be null");
            return this;
        }

        public LinkkiTabSheet build() {
            String descriptionWithFallback = (String)StringUtils.defaultIfBlank((CharSequence)this.description, (CharSequence)"");
            Supplier<Component> nonNullContentSupplier = Objects.requireNonNull(this.contentSupplier, "Content must be specified for a " + LinkkiTabSheet.class.getSimpleName());
            String captionWithFallBack = this.captionComponent == null && this.caption == null ? this.id : Optional.ofNullable(this.caption).orElse("");
            return new LinkkiTabSheet(this.id, captionWithFallBack, this.captionComponent, descriptionWithFallback, nonNullContentSupplier, this.visibilitySupplier, this.selectionChangeListeners);
        }
    }
}

