/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.elasticsearch.indices.analysis.jcseg;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.AnalyzerScope;
import org.elasticsearch.index.analysis.PreBuiltAnalyzerProviderFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.PreBuiltTokenizerFactoryFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;
import org.lionsoul.jcseg.analyzer.v5x.JcsegAnalyzer5X;
import org.lionsoul.jcseg.analyzer.v5x.JcsegTokenizer;
import org.lionsoul.jcseg.elasticsearch.util.CommonUtil;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.DictionaryFactory;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;

public class JcsegIndicesAnalysis
extends AbstractComponent {
    @Inject
    public JcsegIndicesAnalysis(Settings settings, IndicesAnalysisService indicesAnalysisService) {
        super(settings);
        File proFile = new File("plugins/jcseg/jcseg.properties");
        JcsegTaskConfig config = proFile.exists() ? new JcsegTaskConfig(proFile.getPath()) : new JcsegTaskConfig(true);
        ADictionary dic = DictionaryFactory.createSingletonDictionary((JcsegTaskConfig)config);
        indicesAnalysisService.analyzerProviderFactories().put("jcseg", new PreBuiltAnalyzerProviderFactory("jcseg", AnalyzerScope.GLOBAL, (Analyzer)new JcsegAnalyzer5X(CommonUtil.getSegMode(settings, 4), config, dic)));
        indicesAnalysisService.analyzerProviderFactories().put("jcseg_complex", new PreBuiltAnalyzerProviderFactory("jcseg", AnalyzerScope.GLOBAL, (Analyzer)new JcsegAnalyzer5X(2, config, dic)));
        indicesAnalysisService.analyzerProviderFactories().put("jcseg_simple", new PreBuiltAnalyzerProviderFactory("jcseg", AnalyzerScope.GLOBAL, (Analyzer)new JcsegAnalyzer5X(1, config, dic)));
        indicesAnalysisService.analyzerProviderFactories().put("jcseg_detect", new PreBuiltAnalyzerProviderFactory("jcseg", AnalyzerScope.GLOBAL, (Analyzer)new JcsegAnalyzer5X(3, config, dic)));
        indicesAnalysisService.analyzerProviderFactories().put("jcseg_search", new PreBuiltAnalyzerProviderFactory("jcseg", AnalyzerScope.GLOBAL, (Analyzer)new JcsegAnalyzer5X(4, config, dic)));
        indicesAnalysisService.tokenizerFactories().put("jcseg_tokenizer", new PreBuiltTokenizerFactoryFactory(new TokenizerFactory(){

            public String name() {
                return "jcseg_tokenizer";
            }

            public Tokenizer create() {
                try {
                    File proFile = new File("plugins/jcseg/jcseg.properties");
                    JcsegTaskConfig config = proFile.exists() ? new JcsegTaskConfig(proFile.getPath()) : new JcsegTaskConfig(true);
                    return new JcsegTokenizer(2, config, DictionaryFactory.createSingletonDictionary((JcsegTaskConfig)config));
                }
                catch (JcsegException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return null;
            }
        }));
        indicesAnalysisService.tokenFilterFactories().put("jcseg_word", new PreBuiltTokenFilterFactoryFactory(new TokenFilterFactory(){

            public String name() {
                return "jcseg_word";
            }

            public TokenStream create(TokenStream tokenStream) {
                return tokenStream;
            }
        }));
    }
}

