/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.elasticsearch.index.analysis;

import java.io.File;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.lionsoul.jcseg.analyzer.JcsegAnalyzer;

public abstract class JcsegAnalyzerProvider
extends AbstractIndexAnalyzerProvider<JcsegAnalyzer> {
    private final JcsegAnalyzer analyzer;

    @Inject
    public JcsegAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(indexSettings, name, settings);
        File proFile = new File(settings.get("config_file", "plugins/jcseg/jcseg.properties"));
        this.analyzer = proFile.exists() ? new JcsegAnalyzer(this.getSegMode(), proFile.getPath()) : new JcsegAnalyzer(this.getSegMode());
    }

    protected abstract int getSegMode();

    public JcsegAnalyzer get() {
        return this.analyzer;
    }
}

