/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.elasticsearch.index.analysis;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.Tokenizer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.lionsoul.jcseg.analyzer.JcsegTokenizer;
import org.lionsoul.jcseg.elasticsearch.plugin.AnalysisJcsegPlugin;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;

public class JcsegTokenizerTokenizerFactory
extends AbstractTokenizerFactory {
    private final JcsegTaskConfig config = new JcsegTaskConfig((InputStream)new FileInputStream(AnalysisJcsegPlugin.getPluginSafeFile("jcseg.properties")));
    private final ADictionary dic = AnalysisJcsegPlugin.createSingletonDictionary(this.config);
    private final int mode;

    public JcsegTokenizerTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        super(indexSettings, settings);
        String seg_mode = settings.get("seg_mode");
        this.mode = "complex".equals(seg_mode) ? 2 : ("simple".equals(seg_mode) ? 1 : ("detect".equals(seg_mode) ? 3 : ("search".equals(seg_mode) ? 4 : ("nlp".equals(seg_mode) ? 6 : ("delimiter".equals(seg_mode) ? 5 : 4)))));
    }

    public Tokenizer create() {
        try {
            return new JcsegTokenizer(this.mode, this.config, this.dic);
        }
        catch (IOException | JcsegException e) {
            e.printStackTrace();
            return null;
        }
    }
}

