/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.elasticsearch.index.analysis;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.analyzer.JcsegAnalyzer;
import org.lionsoul.jcseg.elasticsearch.plugin.AnalysisJcsegPlugin;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;

public abstract class JcsegAnalyzerProvider
extends AbstractIndexAnalyzerProvider<JcsegAnalyzer> {
    private final JcsegAnalyzer analyzer;

    @Inject
    public JcsegAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) throws IOException {
        super(indexSettings, name, settings);
        SegmenterConfig config = new SegmenterConfig((InputStream)new FileInputStream(AnalysisJcsegPlugin.getPluginSafeFile("jcseg.properties")));
        for (String key : settings.names()) {
            if (!key.startsWith("jcseg_")) continue;
            config.set(key.replace("jcseg_", "jcseg."), settings.get(key));
        }
        this.analyzer = new JcsegAnalyzer(this.getType(), config, AnalysisJcsegPlugin.createSingletonDictionary(config));
    }

    protected abstract ISegment.Type getType();

    public JcsegAnalyzer get() {
        return this.analyzer;
    }
}

