/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.elasticsearch.index.analysis;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.Tokenizer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.analyzer.JcsegTokenizer;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.elasticsearch.plugin.AnalysisJcsegPlugin;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;

public class JcsegTokenizerTokenizerFactory
extends AbstractTokenizerFactory {
    private final SegmenterConfig config = new SegmenterConfig((InputStream)new FileInputStream(AnalysisJcsegPlugin.getPluginSafeFile("jcseg.properties")));
    private final ADictionary dic;
    private final ISegment.Type type;

    public JcsegTokenizerTokenizerFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) throws IOException {
        super(indexSettings, settings, name);
        for (String key : settings.names()) {
            if (!key.startsWith("jcseg_")) continue;
            this.config.set(key.replace("jcseg_", "jcseg."), settings.get(key));
        }
        this.dic = AnalysisJcsegPlugin.createSingletonDictionary(this.config);
        this.type = ISegment.Type.fromString((String)settings.get("seg_mode"));
    }

    public Tokenizer create() {
        try {
            return new JcsegTokenizer(this.type, this.config, this.dic);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

