/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.elasticsearch.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.elasticsearch.common.io.PathUtils;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.indices.analysis.AnalysisModule;
import org.elasticsearch.plugins.AnalysisPlugin;
import org.elasticsearch.plugins.Plugin;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.dic.DictionaryFactory;
import org.lionsoul.jcseg.elasticsearch.index.analysis.JcsegComplexAnalyzerProvider;
import org.lionsoul.jcseg.elasticsearch.index.analysis.JcsegDelimiterAnalyzerProvider;
import org.lionsoul.jcseg.elasticsearch.index.analysis.JcsegDetectAnalyzerProvider;
import org.lionsoul.jcseg.elasticsearch.index.analysis.JcsegMostAnalyzerProvider;
import org.lionsoul.jcseg.elasticsearch.index.analysis.JcsegNGramAnalyzerProvider;
import org.lionsoul.jcseg.elasticsearch.index.analysis.JcsegNLPAnalyzerProvider;
import org.lionsoul.jcseg.elasticsearch.index.analysis.JcsegNoOpTokenFilterFactory;
import org.lionsoul.jcseg.elasticsearch.index.analysis.JcsegSimpleAnalyzerProvider;
import org.lionsoul.jcseg.elasticsearch.index.analysis.JcsegTokenizerTokenizerFactory;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;

public class AnalysisJcsegPlugin
extends Plugin
implements AnalysisPlugin {
    private static final String pluginBase = AnalysisJcsegPlugin.class.getProtectionDomain().getCodeSource().getLocation().getPath();
    private static final Path safePath = PathUtils.get((String)new File(pluginBase).getParent(), (String[])new String[0]).toAbsolutePath();
    private static ADictionary dic = null;
    private static final Object LOCK = new Object();

    public Map<String, AnalysisModule.AnalysisProvider<TokenFilterFactory>> getTokenFilters() {
        return Collections.singletonMap("jcseg_word", JcsegNoOpTokenFilterFactory::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<TokenizerFactory>> getTokenizers() {
        return Collections.singletonMap("jcseg_tokenizer", JcsegTokenizerTokenizerFactory::new);
    }

    public Map<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> getAnalyzers() {
        HashMap<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>> analyzers = new HashMap<String, AnalysisModule.AnalysisProvider<AnalyzerProvider<? extends Analyzer>>>();
        analyzers.put("jcseg", JcsegMostAnalyzerProvider::new);
        analyzers.put("jcseg_simple", JcsegSimpleAnalyzerProvider::new);
        analyzers.put("jcseg_complex", JcsegComplexAnalyzerProvider::new);
        analyzers.put("jcseg_detect", JcsegDetectAnalyzerProvider::new);
        analyzers.put("jcseg_most", JcsegMostAnalyzerProvider::new);
        analyzers.put("jcseg_nlp", JcsegNLPAnalyzerProvider::new);
        analyzers.put("jcseg_delimiter", JcsegDelimiterAnalyzerProvider::new);
        analyzers.put("jcseg_ngram", JcsegNGramAnalyzerProvider::new);
        return analyzers;
    }

    public static final File getPluginSafeFile(String file) {
        return safePath.resolve(file).toFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ADictionary createSingletonDictionary(SegmenterConfig config) throws IOException {
        Object object = LOCK;
        synchronized (object) {
            if (dic != null) {
                return dic;
            }
            boolean autoLoad = config.isAutoload();
            config.setAutoload(false);
            dic = DictionaryFactory.createDefaultDictionary((SegmenterConfig)config, (boolean)false);
            config.setAutoload(autoLoad);
            String[] lexPath = config.getLexiconPath();
            if (lexPath == null) {
                dic.loadClassPath();
                dic.resetSynonymsNet();
                return dic;
            }
            for (String path : lexPath) {
                File[] files;
                File safeDir = AnalysisJcsegPlugin.getPluginSafeFile(path);
                if (!safeDir.exists()) {
                    throw new IOException("Lexicon directory [" + safeDir + "] does'n exists.");
                }
                for (File f : files = safeDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.startsWith("lex-") && name.endsWith(".lex");
                    }
                })) {
                    dic.load(AnalysisJcsegPlugin.getPluginSafeFile(f.getAbsolutePath()));
                }
            }
            if (config.isAutoload()) {
                dic.startAutoload();
            }
            dic.resetSynonymsNet();
            return dic;
        }
    }
}

