/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.lionsoul.jcseg.json.JSONArray;
import org.lionsoul.jcseg.json.JSONObject;
import org.lionsoul.jcseg.server.JcsegGlobalResource;
import org.lionsoul.jcseg.server.JcsegResourceHandler;
import org.lionsoul.jcseg.server.JcsegServerConfig;
import org.lionsoul.jcseg.server.JcsegTokenizerEntry;
import org.lionsoul.jcseg.server.controller.KeyphraseController;
import org.lionsoul.jcseg.server.controller.KeywordsController;
import org.lionsoul.jcseg.server.controller.MainController;
import org.lionsoul.jcseg.server.controller.SentenceController;
import org.lionsoul.jcseg.server.controller.SummaryController;
import org.lionsoul.jcseg.server.controller.TokenizerController;
import org.lionsoul.jcseg.server.core.AbstractRouter;
import org.lionsoul.jcseg.server.core.DynamicRestRouter;
import org.lionsoul.jcseg.server.core.ServerConfig;
import org.lionsoul.jcseg.server.core.StandardHandler;
import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.tokenizer.core.DictionaryFactory;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.JcsegTaskConfig;
import org.lionsoul.jcseg.util.Util;

public class JcsegServer {
    private ServerConfig config;
    private Server server;
    private JcsegGlobalResource resourcePool = null;

    public JcsegServer(ServerConfig config) {
        this.config = config;
        this.resourcePool = new JcsegGlobalResource();
    }

    private void init() {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMaxThreads(this.config.getMaxThreadPoolSize());
        threadPool.setIdleTimeout(this.config.getThreadIdleTimeout());
        this.server = new Server(threadPool);
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setOutputBufferSize(this.config.getOutputBufferSize());
        http_config.setRequestHeaderSize(this.config.getRequestHeaderSize());
        http_config.setResponseHeaderSize(this.config.getResponseHeaderSize());
        http_config.setSendServerVersion(false);
        http_config.setSendDateHeader(false);
        ServerConnector connector = new ServerConnector(this.server, new HttpConnectionFactory(http_config));
        connector.setPort(this.config.getPort());
        connector.setHost(this.config.getHost());
        connector.setIdleTimeout(this.config.getHttpIdleTimeout());
        this.server.addConnector(connector);
    }

    public JcsegServer registerHandler() {
        String basePath = this.getClass().getPackage().getName() + ".controller";
        DynamicRestRouter router = new DynamicRestRouter(basePath, MainController.class);
        ((AbstractRouter)router).addMapping("/extractor/keywords", KeywordsController.class);
        ((AbstractRouter)router).addMapping("/extractor/keyphrase", KeyphraseController.class);
        ((AbstractRouter)router).addMapping("/extractor/sentence", SentenceController.class);
        ((AbstractRouter)router).addMapping("/extractor/summary", SummaryController.class);
        ((AbstractRouter)router).addMapping("/tokenizer/default", TokenizerController.class);
        StandardHandler stdHandler = new StandardHandler(this.config, this.resourcePool, router);
        JcsegResourceHandler resourceHandler = new JcsegResourceHandler();
        GzipHandler gzipHandler = new GzipHandler();
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{stdHandler, resourceHandler});
        gzipHandler.setHandler(handlers);
        this.server.setHandler(gzipHandler);
        return this;
    }

    public JcsegServer initFromGlobalConfig(JSONObject globalConfig) throws CloneNotSupportedException, JcsegException {
        if (globalConfig.has("server_config")) {
            JSONObject serverSetting = globalConfig.getJSONObject("server_config");
            if (serverSetting.has("port")) {
                this.config.setPort(serverSetting.getInt("port"));
            }
            if (serverSetting.has("charset")) {
                this.config.setCharset(serverSetting.getString("charset"));
            }
            if (serverSetting.has("max_thread_pool_size")) {
                this.config.setMaxThreadPoolSize(serverSetting.getInt("max_thread_pool_size"));
            }
            if (serverSetting.has("thread_idle_timeout")) {
                this.config.setThreadIdleTimeout(serverSetting.getInt("thread_idle_timeout"));
            }
            if (serverSetting.has("http_output_buffer_size")) {
                this.config.setOutputBufferSize(serverSetting.getInt("http_output_buffer_size"));
            }
            if (serverSetting.has("http_request_header_size")) {
                this.config.setRequestHeaderSize(serverSetting.getInt("http_request_header_size"));
            }
            if (serverSetting.has("http_response_header_size")) {
                this.config.setResponseHeaderSize(serverSetting.getInt("http_connection_idle_timeout"));
            }
        }
        JcsegTaskConfig globalJcsegTaskConfig = new JcsegTaskConfig(false);
        if (globalConfig.has("jcseg_global_config")) {
            JSONObject globalSetting = globalConfig.getJSONObject("jcseg_global_config");
            this.resetJcsegTaskConfig(globalJcsegTaskConfig, globalSetting);
        }
        JcsegTaskConfig dictLoadConfig = globalJcsegTaskConfig.clone();
        dictLoadConfig.setMaxLength(100);
        if (globalConfig.has("jcseg_dict")) {
            String[] dictNames;
            JSONObject dictSetting = globalConfig.getJSONObject("jcseg_dict");
            for (String name : dictNames = JSONObject.getNames(dictSetting)) {
                JSONObject dicJson = dictSetting.getJSONObject(name);
                if (!dicJson.has("path")) {
                    throw new JcsegException("Missing path for dict instance " + name);
                }
                String[] lexPath = null;
                if (!dicJson.isNull("path")) {
                    JSONArray path = dicJson.getJSONArray("path");
                    ArrayList<String> dicPath = new ArrayList<String>();
                    for (int i = 0; i < path.length(); ++i) {
                        String filePath = path.get(i).toString();
                        if (filePath.indexOf("{jar.dir}") > -1) {
                            filePath = filePath.replace("{jar.dir}", Util.getJarHome(this));
                        }
                        dicPath.add(filePath);
                    }
                    lexPath = new String[dicPath.size()];
                    dicPath.toArray(lexPath);
                    dicPath.clear();
                    dicPath = null;
                }
                boolean loadpos = dicJson.has("loadpos") ? dicJson.getBoolean("loadpos") : true;
                boolean loadpinyin = dicJson.has("loadpinyin") ? dicJson.getBoolean("loadpinyin") : true;
                boolean loadsyn = dicJson.has("loadsyn") ? dicJson.getBoolean("loadsyn") : true;
                boolean loadentity = dicJson.has("loadentity") ? dicJson.getBoolean("loadentity") : true;
                boolean autoload = dicJson.has("autoload") ? dicJson.getBoolean("autoload") : false;
                int polltime = dicJson.has("polltime") ? dicJson.getInt("polltime") : 300;
                dictLoadConfig.setLoadCJKPinyin(loadpinyin);
                dictLoadConfig.setLoadCJKPos(loadpos);
                dictLoadConfig.setLoadCJKSyn(loadsyn);
                dictLoadConfig.setLoadEntity(loadentity);
                dictLoadConfig.setAutoload(autoload);
                dictLoadConfig.setPollTime(polltime);
                dictLoadConfig.setLexiconPath(lexPath);
                ADictionary dic = DictionaryFactory.createDefaultDictionary(dictLoadConfig);
                this.resourcePool.addDict(name, dic);
            }
        }
        dictLoadConfig = null;
        if (globalConfig.has("jcseg_config")) {
            String[] configNames;
            JSONObject configSetting = globalConfig.getJSONObject("jcseg_config");
            for (String name : configNames = JSONObject.getNames(configSetting)) {
                JSONObject configJson = configSetting.getJSONObject(name);
                JcsegTaskConfig config = globalJcsegTaskConfig.clone();
                if (configJson.length() > 0) {
                    this.resetJcsegTaskConfig(config, configJson);
                }
                this.resourcePool.addConfig(name, config);
            }
        }
        if (globalConfig.has("jcseg_tokenizer")) {
            String[] tokenizerNames;
            JSONObject tokenizerSetting = globalConfig.getJSONObject("jcseg_tokenizer");
            for (String name : tokenizerNames = JSONObject.getNames(tokenizerSetting)) {
                int algorithm;
                JSONObject tokenizerJson = tokenizerSetting.getJSONObject(name);
                int n = algorithm = tokenizerJson.has("algorithm") ? tokenizerJson.getInt("algorithm") : 2;
                if (!tokenizerJson.has("dict")) {
                    throw new JcsegException("Missing dict setting for tokenizer " + name);
                }
                if (!tokenizerJson.has("config")) {
                    throw new JcsegException("Missing config setting for tokenizer " + name);
                }
                ADictionary dic = this.resourcePool.getDict(tokenizerJson.getString("dict"));
                JcsegTaskConfig config = this.resourcePool.getConfig(tokenizerJson.getString("config"));
                if (dic == null) {
                    throw new JcsegException("Unknow dict instance " + tokenizerJson.getString("dict") + " for tokenizer " + name);
                }
                if (config == null) {
                    throw new JcsegException("Unknow config instance " + tokenizerJson.getString("config") + " for tokenizer " + name);
                }
                this.resourcePool.addTokenizerEntry(name, new JcsegTokenizerEntry(algorithm, config, dic));
            }
        }
        this.init();
        return this;
    }

    private void resetJcsegTaskConfig(JcsegTaskConfig config, JSONObject json) {
        if (json.has("jcseg_maxlen")) {
            config.setMaxLength(json.getInt("jcseg_maxlen"));
        }
        if (json.has("jcseg_icnname")) {
            config.setICnName(json.getBoolean("jcseg_icnname"));
        }
        if (json.has("jcseg_pptmaxlen")) {
            config.setPPT_MAX_LENGTH(json.getInt("jcseg_pptmaxlen"));
        }
        if (json.has("jcseg_cnmaxlnadron")) {
            config.setMaxCnLnadron(json.getInt("jcseg_cnmaxlnadron"));
        }
        if (json.has("jcseg_clearstopword")) {
            config.setClearStopwords(json.getBoolean("jcseg_clearstopword"));
        }
        if (json.has("jcseg_cnnumtoarabic")) {
            config.setCnNumToArabic(json.getBoolean("jcseg_cnnumtoarabic"));
        }
        if (json.has("jcseg_cnfratoarabic")) {
            config.setCnFactionToArabic(json.getBoolean("jcseg_cnfratoarabic"));
        }
        if (json.has("jcseg_keepunregword")) {
            config.setKeepUnregWords(json.getBoolean("jcseg_keepunregword"));
        }
        if (json.has("jcseg_ensencondseg")) {
            config.setEnSecondSeg(json.getBoolean("jcseg_ensencondseg"));
        }
        if (json.has("jcseg_stokenminlen")) {
            config.setSTokenMinLen(json.getInt("jcseg_stokenminlen"));
        }
        if (json.has("jcseg_nsthreshold")) {
            config.setNameSingleThreshold(json.getInt("jcseg_nsthreshold"));
        }
        if (json.has("jcseg_keeppunctuations")) {
            config.setKeepPunctuations(json.getString("jcseg_keeppunctuations"));
        }
    }

    public void start() throws Exception {
        if (this.server != null) {
            this.server.start();
            this.server.join();
        }
    }

    public void stop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public static void main(String[] args) {
        JcsegServerConfig config = new JcsegServerConfig();
        String proFile = null;
        if (args.length > 0) {
            proFile = args[0];
        }
        if (proFile == null) {
            String[] rPaths = new String[]{"jcseg-server.properties", "classes/jcseg-server.properties"};
            String jarHome = Util.getJarHome(config);
            for (String path : rPaths) {
                File pFile = new File(jarHome + "/" + path);
                if (!pFile.exists()) continue;
                proFile = pFile.getAbsolutePath();
                break;
            }
        }
        if (proFile == null) {
            System.out.println("Usage: java -jar jcseg-server-{version}.jar \"path of file jcseg-server properties\"");
            return;
        }
        try {
            System.out.println("+-Try to load and parse server property file \"" + proFile + "\"");
            config.resetFromFile(proFile);
            JcsegServer server = new JcsegServer(config);
            System.out.print("+-[Info]: initializing ... ");
            server.initFromGlobalConfig(config.getGlobalConfig());
            System.out.println(" --[Ok]");
            System.out.print("+-[Info]: Register handler ... ");
            server.registerHandler();
            System.out.println(" --[Ok]");
            server.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

