/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server.controller;

import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.lionsoul.jcseg.server.JcsegController;
import org.lionsoul.jcseg.server.JcsegGlobalResource;
import org.lionsoul.jcseg.server.JcsegTokenizerEntry;
import org.lionsoul.jcseg.server.core.GlobalResource;
import org.lionsoul.jcseg.server.core.ServerConfig;
import org.lionsoul.jcseg.server.core.UriEntry;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.IWord;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.SegmentFactory;

public class TokenizerController
extends JcsegController {
    public TokenizerController(ServerConfig config, GlobalResource resourcePool, UriEntry uriEntry, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        super(config, resourcePool, uriEntry, baseRequest, request, response);
    }

    @Override
    protected void run(String method) throws IOException {
        String text = this.getString("text");
        if (text == null || "".equals(text)) {
            this.response(1, "Invalid Arguments");
            return;
        }
        JcsegGlobalResource resourcePool = (JcsegGlobalResource)this.globalResource;
        JcsegTokenizerEntry tokenizerEntry = resourcePool.getTokenizerEntry(method);
        if (tokenizerEntry == null) {
            this.response(1, "can't find tokenizer instance [" + method + "]");
            return;
        }
        try {
            ISegment seg = SegmentFactory.createJcseg(tokenizerEntry.getAlgorithm(), tokenizerEntry.getConfig(), tokenizerEntry.getDict());
            IWord word = null;
            ArrayList<IWord> list = new ArrayList<IWord>();
            seg.reset(new StringReader(text));
            long s_time = System.nanoTime();
            while ((word = seg.next()) != null) {
                list.add(word);
            }
            double c_time = (double)(System.nanoTime() - s_time) / 1.0E9;
            HashMap<String, Object> map = new HashMap<String, Object>();
            DecimalFormat df = new DecimalFormat("0.00000");
            map.put("took", Float.valueOf(df.format(c_time)));
            map.put("list", list);
            this.response(0, map);
        }
        catch (JcsegException e) {
            this.response(-1, "Internal error...");
        }
    }
}

