/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.lionsoul.jcseg.server.core.GlobalResource;
import org.lionsoul.jcseg.server.core.ServerConfig;
import org.lionsoul.jcseg.server.core.UriEntry;

public abstract class Controller {
    protected ServerConfig config;
    protected GlobalResource globalResource;
    protected Request baseRequest;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected PrintWriter output = null;
    protected UriEntry uri;

    public Controller(ServerConfig config, GlobalResource globalResource, UriEntry uriEntry, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.config = config;
        this.globalResource = globalResource;
        this.uri = uriEntry;
        this.baseRequest = baseRequest;
        this.request = request;
        this.response = response;
        this.init();
        this.output = response.getWriter();
    }

    private void init() {
        this.response.setCharacterEncoding(this.config.getCharset());
        this.response.setContentType("text/html;charset=" + this.config.getCharset());
        this.response.setStatus(200);
    }

    protected void run(String method) throws IOException {
    }

    public String getString(String name) {
        return this.request.getParameter(name);
    }

    public String getEncodeString(String name) {
        String v = this.request.getParameter(name);
        if (!this.config.isDefaultCharset()) {
            try {
                v = new String(v.getBytes("iso-8859-1"), this.config.getCharset());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return v;
    }

    public int getInt(String name) {
        int val = 0;
        try {
            val = Integer.valueOf(this.request.getParameter(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public int getInt(String name, int val) {
        String v = this.request.getParameter(name);
        if (v == null) {
            return val;
        }
        return this.getInt(name);
    }

    public float getFloat(String name) {
        float fval = 0.0f;
        try {
            fval = Float.valueOf(this.request.getParameter(name)).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return fval;
    }

    public float getFloat(String name, float val) {
        String v = this.request.getParameter(name);
        if (v == null) {
            return val;
        }
        return this.getFloat(name);
    }

    public long getLong(String name) {
        long val = 0L;
        try {
            val = Long.valueOf(this.request.getParameter(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public long getLong(String name, long val) {
        String v = this.request.getParameter(name);
        if (v == null) {
            return val;
        }
        return this.getLong(name);
    }

    public double getDouble(String name) {
        double val = 0.0;
        try {
            val = Double.valueOf(this.request.getParameter(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public double getDouble(String name, double val) {
        String v = this.request.getParameter(name);
        if (v == null) {
            return val;
        }
        return this.getDouble(name);
    }

    public boolean getBoolean(String name) {
        boolean val = false;
        try {
            val = Boolean.valueOf(this.request.getParameter(name));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    public boolean getBoolean(String name, boolean val) {
        String v = this.request.getParameter(name);
        if (v == null) {
            return val;
        }
        return this.getBoolean(name);
    }

    public void redirect(String path) throws IOException {
        this.response.sendRedirect(path.charAt(0) == '/' ? path : "/" + path);
        this.output.close();
    }
}

