/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server.core;

import java.util.ArrayList;
import java.util.List;
import org.lionsoul.jcseg.util.IStringBuffer;

public class UriEntry {
    private String requestUri;
    private List<String> parts = null;
    private String controller = null;
    private String method = null;

    public static UriEntry parseRequestUri(String requestUri) {
        return new UriEntry(requestUri);
    }

    public UriEntry(String requestUri) {
        this.requestUri = requestUri;
        this.process();
    }

    private void process() {
        if (this.requestUri.length() > 1) {
            int length;
            this.parts = new ArrayList<String>(10);
            int i = 1;
            while (i < this.requestUri.length()) {
                int sIdx = i;
                int eIdx = this.requestUri.indexOf(47, sIdx + 1);
                if (eIdx == -1) {
                    this.parts.add(this.requestUri.substring(sIdx));
                    break;
                }
                this.parts.add(this.requestUri.substring(sIdx, eIdx));
                i = eIdx + 1;
            }
            if (this.requestUri.charAt(this.requestUri.length() - 1) == '/') {
                this.parts.add("");
            }
            if ((length = this.parts.size()) > 1) {
                IStringBuffer sb = new IStringBuffer();
                for (int i2 = 0; i2 < length - 1; ++i2) {
                    int l = sb.length();
                    sb.append(this.parts.get(i2));
                    char chr = sb.charAt(l);
                    if (chr < 'Z') continue;
                    chr = (char)(chr - 32);
                    sb.set(l, chr);
                }
                this.controller = sb.toString();
            }
            this.method = this.parts.get(length - 1);
        }
    }

    public String get(int idx) {
        if (idx < 0 || idx >= this.parts.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.parts.get(idx);
    }

    public int getLength() {
        return this.parts == null ? 0 : this.parts.size();
    }

    public String getController() {
        return this.controller;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }
}

