/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server.util;

import java.util.HashMap;

public class LRUCache<E, T> {
    private int capacity = 32;
    private int removePercent = 10;
    private int length = 0;
    private HashMap<E, Entry<E, T>> map = null;
    private Entry<E, T> head;
    private Entry<E, T> tail;

    public LRUCache(int capacity) {
        this.capacity = capacity;
        this.init();
    }

    public LRUCache(int capacity, int percentToRemove) {
        this.capacity = capacity;
        this.removePercent = percentToRemove;
        this.init();
    }

    private void init() {
        this.head = new Entry<Object, Object>(null, null, null, null);
        this.tail = new Entry<Object, Object>(null, null, this.head, null);
        this.head.next = this.tail;
        this.map = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(E key) {
        Entry<E, T> entry = null;
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            entry = this.map.get(key);
            if (this.map.get(key) == null) {
                return null;
            }
            entry.prev.next = entry.next;
            entry.next.prev = entry.prev;
            entry.prev = this.head;
            entry.next = this.head.next;
            this.head.next.prev = entry;
            this.head.next = entry;
        }
        return entry.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(E key, T value) {
        Entry<E, T> entry = new Entry<E, T>(key, value, null, null);
        LRUCache lRUCache = this;
        synchronized (lRUCache) {
            if (this.map.get(key) == null) {
                if (this.length >= this.capacity) {
                    this.removeLeastUsedElements();
                }
                entry.prev = this.head;
                entry.next = this.head.next;
                this.head.next.prev = entry;
                this.head.next = entry;
                ++this.length;
                this.map.put(key, entry);
            } else {
                entry = this.map.get(key);
                entry.value = value;
                entry.prev.next = entry.next;
                entry.next.prev = entry.prev;
                entry.prev = this.head;
                entry.next = this.head.next;
                this.head.next.prev = entry;
                this.head.next = entry;
            }
        }
    }

    public synchronized void remove(E key) {
        Entry<E, T> entry = this.map.get(key);
        this.tail.prev = entry.prev;
        entry.prev.next = this.tail;
        this.map.remove(entry.key);
        --this.length;
    }

    public synchronized void removeLeastUsedElements() {
        int rows = this.removePercent / 100 * this.length;
        int n = rows = rows == 0 ? 1 : rows;
        while (rows > 0 && this.length > 0) {
            Entry entry = this.tail.prev;
            this.tail.prev = entry.prev;
            entry.prev.next = this.tail;
            this.map.remove(entry.key);
            --this.length;
            --rows;
        }
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void printList() {
        Entry entry = this.head.next;
        System.out.println("\n|----- key list----|");
        while (entry != this.tail) {
            System.out.println(" -> " + entry.key);
            entry = entry.next;
        }
        System.out.println("|------- end --------|\n");
    }

    private class Entry<E, T> {
        public E key;
        public T value;
        public Entry<E, T> prev;
        public Entry<E, T> next;

        public Entry(E _key, T _val, Entry<E, T> _prev, Entry<E, T> _next) {
            this.key = _key;
            this.value = _val;
            this.prev = _prev;
            this.next = _next;
        }
    }
}

