/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.tokenizer;

import org.lionsoul.jcseg.tokenizer.core.IWord;

public class Word
implements IWord,
Cloneable {
    private String value;
    private int fre = 0;
    private int type;
    private int position;
    private int length = -1;
    private int h = -1;
    private String entity = null;
    private String pinyin = null;
    private String[] partspeech = null;
    private String[] syn = null;

    public Word(String value, int fre, int type, String entity) {
        this.value = value;
        this.fre = fre;
        this.type = type;
        this.entity = entity;
    }

    public Word(String value, int fre, int type) {
        this(value, fre, type, null);
    }

    public Word(String value, int type) {
        this(value, 0, type, null);
    }

    public Word(String value, int type, String entity) {
        this(value, 0, type, entity);
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int getLength() {
        return this.length == -1 ? this.value.length() : this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    @Override
    public int getFrequency() {
        return this.fre;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setPosition(int pos) {
        this.position = pos;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public String getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(String entity) {
        this.entity = entity;
    }

    @Override
    public String getPinyin() {
        return this.pinyin;
    }

    @Override
    public String[] getSyn() {
        return this.syn;
    }

    @Override
    public void setSyn(String[] syn) {
        this.syn = syn;
    }

    @Override
    public String[] getPartSpeech() {
        return this.partspeech;
    }

    @Override
    public void setPartSpeech(String[] partspeech) {
        this.partspeech = partspeech;
    }

    @Override
    public void setPinyin(String py) {
        this.pinyin = py;
    }

    @Override
    public void addPartSpeech(String ps) {
        if (this.partspeech == null) {
            this.partspeech = new String[1];
            this.partspeech[0] = ps;
        } else {
            String[] bak = this.partspeech;
            this.partspeech = new String[this.partspeech.length + 1];
            for (int j = 0; j < bak.length; ++j) {
                this.partspeech[j] = bak[j];
            }
            this.partspeech[j] = ps;
            Object var2_2 = null;
        }
    }

    @Override
    public void addSyn(String s) {
        if (this.syn == null) {
            this.syn = new String[1];
            this.syn[0] = s;
        } else {
            String[] tycA = this.syn;
            this.syn = new String[this.syn.length + 1];
            for (int j = 0; j < tycA.length; ++j) {
                this.syn[j] = tycA[j];
            }
            this.syn[j] = s;
            Object var2_2 = null;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IWord) {
            IWord word = (IWord)o;
            boolean bool = word.getValue().equalsIgnoreCase(this.getValue());
            return bool && word.getType() == this.getType();
        }
        return false;
    }

    @Override
    public IWord clone() {
        IWord w = null;
        try {
            w = (IWord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return w;
    }

    public String __toString() {
        int j;
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        sb.append('/');
        if (this.partspeech != null) {
            for (j = 0; j < this.partspeech.length; ++j) {
                if (j == 0) {
                    sb.append(this.partspeech[j]);
                    continue;
                }
                sb.append(',');
                sb.append(this.partspeech[j]);
            }
        } else {
            sb.append("null");
        }
        sb.append('/');
        sb.append(this.pinyin);
        sb.append('/');
        if (this.syn != null) {
            for (j = 0; j < this.syn.length; ++j) {
                if (j == 0) {
                    sb.append(this.syn[j]);
                    continue;
                }
                sb.append(',');
                sb.append(this.syn[j]);
            }
        } else {
            sb.append("null");
        }
        if (this.value.length() == 1) {
            sb.append('/');
            sb.append(this.fre);
        }
        if (this.entity != null) {
            sb.append('/');
            sb.append(this.entity);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        sb.append("\"word\":\"").append(this.value).append('\"');
        sb.append(",\"position\":").append(this.position);
        sb.append(",\"length\":").append(this.getLength());
        if (this.pinyin != null) {
            sb.append(",\"pinyin\":\"").append(this.pinyin).append('\"');
        } else {
            sb.append(",\"pinyin\":null");
        }
        if (this.partspeech != null) {
            sb.append(",\"pos\":\"").append(this.partspeech[0]).append('\"');
        } else {
            sb.append(",\"pos\":null");
        }
        if (this.entity != null) {
            sb.append(",\"entity\":\"").append(this.entity).append('\"');
        } else {
            sb.append(",\"entity\":null");
        }
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        if (this.h == -1) {
            this.h = 5381;
            for (int j = 0; j < this.value.length(); ++j) {
                this.h = this.h * 33 ^ this.value.charAt(j);
            }
            this.h &= Integer.MAX_VALUE;
        }
        return this.h;
    }
}

