/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

import org.lionsoul.jcseg.tokenizer.core.ADictionary;
import org.lionsoul.jcseg.util.StringUtil;

public class EntityFormat {
    public static boolean isMailAddress(String str) {
        int ptIndex;
        int atIndex = str.indexOf(64);
        if (atIndex == -1) {
            return false;
        }
        if (!StringUtil.isLetterOrNumeric(str, 0, atIndex)) {
            return false;
        }
        int ptStart = atIndex + 1;
        while ((ptIndex = str.indexOf(46, ptStart)) > 0) {
            if (ptIndex == ptStart) {
                return false;
            }
            if (!StringUtil.isLetterOrNumeric(str, ptStart, ptIndex)) {
                return false;
            }
            ptStart = ptIndex + 1;
        }
        return ptStart >= str.length() || StringUtil.isLetterOrNumeric(str, ptStart, str.length());
    }

    public static boolean isUrlAddress(String str, ADictionary dic) {
        char chr;
        int i;
        int prIndex = str.indexOf("://");
        if (prIndex > -1 && !StringUtil.isLatin(str, 0, prIndex)) {
            return false;
        }
        int sIdx = prIndex > -1 ? prIndex + 3 : 0;
        int slIndex = str.indexOf(47, sIdx);
        int sgIndex = str.indexOf(63, sIdx);
        int eIdx = slIndex > -1 ? slIndex : (sgIndex > -1 ? sgIndex : str.length());
        int lpIndex = -1;
        for (i = sIdx; i < eIdx; ++i) {
            chr = str.charAt(i);
            if (chr == '.') {
                if (lpIndex == -1) {
                    lpIndex = i;
                    continue;
                }
                if (i - lpIndex == 1 || i == eIdx - 1) {
                    return false;
                }
                lpIndex = i;
                continue;
            }
            if (StringUtil.isEnLetter(chr) || StringUtil.isEnNumeric(chr)) continue;
            return false;
        }
        if (dic != null && !dic.match(9, str.substring(lpIndex + 1, eIdx))) {
            return false;
        }
        if (slIndex > -1) {
            sIdx = slIndex;
            eIdx = sgIndex > -1 ? sgIndex : str.length();
            lpIndex = -1;
            for (i = sIdx; i < eIdx; ++i) {
                chr = str.charAt(i);
                if ("./-_".indexOf(chr) > -1) {
                    if (lpIndex == -1) {
                        lpIndex = i;
                        continue;
                    }
                    if (i - lpIndex == 1 || chr == '.' && i == eIdx - 1) {
                        return false;
                    }
                    lpIndex = i;
                    continue;
                }
                if (StringUtil.isEnLetter(chr) || StringUtil.isEnNumeric(chr)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isMobileNumber(String str) {
        if (str.length() != 11) {
            return false;
        }
        if (str.charAt(0) != '1') {
            return false;
        }
        if ("34578".indexOf(str.charAt(1)) == -1) {
            return false;
        }
        return StringUtil.isNumeric(str, 2, str.length());
    }

    public static boolean isIpAddress(String str) {
        int eIdx;
        if (str.length() < 7 && str.length() > 15) {
            return false;
        }
        int sIdx = 0;
        while ((eIdx = str.indexOf(46, sIdx)) > -1) {
            int diff = eIdx - sIdx;
            switch (diff) {
                case 0: {
                    return false;
                }
                case 1: 
                case 2: {
                    if (StringUtil.isNumeric(str, sIdx, eIdx)) break;
                    return false;
                }
                case 3: {
                    char chr = str.charAt(sIdx);
                    if (chr == '1') {
                        if (StringUtil.isNumeric(str, sIdx + 1, eIdx)) break;
                        return false;
                    }
                    if (chr != '2') break;
                    chr = str.charAt(sIdx + 1);
                    if (chr < '0' || chr > '5') {
                        return false;
                    }
                    chr = str.charAt(sIdx + 2);
                    if (chr >= '0' && chr <= '5') break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            sIdx = eIdx + 1;
        }
        return true;
    }
}

