/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.thread;

import java.util.concurrent.atomic.AtomicReference;

public class SpinLock {
    private final AtomicReference<Thread> _lock = new AtomicReference<Object>(null);
    private final Lock _unlock = new Lock();

    public Lock lock() {
        Thread locker;
        Thread current = Thread.currentThread();
        while ((locker = this._lock.get()) != null || !this._lock.compareAndSet(null, current)) {
            if (locker != current) continue;
            throw new IllegalStateException("SpinLock is not reentrant");
        }
        return this._unlock;
    }

    public boolean isLocked() {
        return this._lock.get() != null;
    }

    public class Lock
    implements AutoCloseable {
        @Override
        public void close() {
            SpinLock.this._lock.set(null);
        }
    }
}

