/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.lionsoul.jcseg.server.core.Controller;
import org.lionsoul.jcseg.server.core.GlobalResource;
import org.lionsoul.jcseg.server.core.JSONWriter;
import org.lionsoul.jcseg.server.core.ServerConfig;
import org.lionsoul.jcseg.server.core.UriEntry;

public class JcsegController
extends Controller {
    public static final int STATUS_INTERNEL_ERROR = -1;
    public static final int STATUS_OK = 0;
    public static final int STATUS_INVALID_ARGS = 1;
    public static final int STATUS_NO_SESSION = 2;
    public static final int STATUS_EMPTY_SETS = 3;
    public static final int STATUS_FAILED = 4;
    public static final int STATUS_DUPLICATE = 5;
    public static final int STATUS_ACCESS_DENY = 6;

    public JcsegController(ServerConfig setting, GlobalResource resourcePool, UriEntry uriEntry, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        super(setting, resourcePool, uriEntry, baseRequest, request, response);
    }

    protected void response(int code, String data) {
        this.response.setContentType("application/json;charset=" + this.config.getCharset());
        JSONWriter json = JSONWriter.create().put("code", code).put("data", data);
        this.output.println(json.toString());
        this.output.flush();
        json = null;
    }

    protected void response(int code, List<Object> data) {
        this.response(code, JSONWriter.list2JsonString(data));
    }

    protected void response(int code, Object[] data) {
        this.response(code, JSONWriter.vector2JsonString(data));
    }

    protected void response(int code, Map<String, Object> data) {
        this.response(code, JSONWriter.map2JsonString(data));
    }
}

