/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server.core;

import java.util.HashMap;
import java.util.Map;
import org.lionsoul.jcseg.server.core.AbstractRouter;
import org.lionsoul.jcseg.server.core.Controller;
import org.lionsoul.jcseg.server.core.UriEntry;

public class DynamicRestRouter
extends AbstractRouter {
    private String basePath = null;
    private Map<String, Class<? extends Controller>> mapping = null;

    public DynamicRestRouter(String basePath, Class<? extends Controller> defaultController) {
        super(defaultController);
        this.basePath = basePath;
        this.mapping = new HashMap<String, Class<? extends Controller>>();
    }

    @Override
    public void addMapping(String path, Class<? extends Controller> _class) {
        this.mapping.put(path, _class);
    }

    @Override
    public void removeMapping(String path) {
        this.mapping.remove(path);
    }

    @Override
    public Class<? extends Controller> getController(UriEntry uriEntry) {
        Class<?> controller = null;
        String requireUri = uriEntry.getRequestUri();
        if (this.mapping.containsKey(requireUri)) {
            controller = this.mapping.get(requireUri);
        } else {
            String cClass = uriEntry.getController();
            String method = uriEntry.getMethod();
            if (cClass != null && method != null) {
                String _clsname = this.basePath + "." + cClass + "Controller";
                try {
                    Class<?> _class = Class.forName(_clsname);
                    if (Controller.class.isAssignableFrom(_class)) {
                        controller = _class;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        return controller == null ? this.defaultController : controller;
    }
}

