/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server.core;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lionsoul.jcseg.util.IStringBuffer;

public class JSONWriter {
    private Map<String, Object> data = new HashMap<String, Object>();

    public static JSONWriter create() {
        return new JSONWriter();
    }

    public JSONWriter put(String key, Object obj) {
        this.data.put(key, obj);
        return this;
    }

    public JSONWriter put(String key, Object[] vector) {
        this.data.put(key, JSONWriter.vector2JsonString(vector));
        return this;
    }

    public String toString() {
        return JSONWriter.map2JsonString(this.data);
    }

    public static String vector2JsonString(Object[] vector) {
        IStringBuffer sb = new IStringBuffer();
        sb.append('[');
        for (Object o : vector) {
            if (o instanceof List) {
                sb.append(JSONWriter.list2JsonString((List)o)).append(',');
                continue;
            }
            if (o instanceof Object[]) {
                sb.append(JSONWriter.vector2JsonString((Object[])o)).append(',');
                continue;
            }
            if (o instanceof Map) {
                sb.append(JSONWriter.map2JsonString((Map)o)).append(',');
                continue;
            }
            if (o instanceof Boolean || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double) {
                sb.append(o.toString()).append(',');
                continue;
            }
            String v = o.toString();
            int last = v.length() - 1;
            if (v.length() > 1 && (v.charAt(0) == '{' && v.charAt(last) == '}' || v.charAt(0) == '[' && v.charAt(last) == ']')) {
                sb.append(v).append(',');
                continue;
            }
            sb.append('\"').append(v).append("\",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String list2JsonString(List<Object> list) {
        IStringBuffer sb = new IStringBuffer();
        sb.append('[');
        for (Object o : list) {
            if (o instanceof List) {
                sb.append(JSONWriter.list2JsonString((List)o)).append(',');
                continue;
            }
            if (o instanceof Object[]) {
                sb.append(JSONWriter.vector2JsonString((Object[])o)).append(',');
                continue;
            }
            if (o instanceof Map) {
                sb.append(JSONWriter.map2JsonString((Map)o)).append(',');
                continue;
            }
            if (o instanceof Boolean || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double) {
                sb.append(o.toString()).append(',');
                continue;
            }
            String v = o.toString();
            int last = v.length() - 1;
            if (v.length() > 1 && (v.charAt(0) == '{' && v.charAt(last) == '}' || v.charAt(0) == '[' && v.charAt(last) == ']')) {
                sb.append(v).append(',');
                continue;
            }
            sb.append('\"').append(v).append("\",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append(']');
        return sb.toString();
    }

    public static String map2JsonString(Map<String, Object> map) {
        IStringBuffer sb = new IStringBuffer();
        sb.append('{');
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append('\"').append(entry.getKey().toString()).append("\": ");
            Object obj = entry.getValue();
            if (obj instanceof List) {
                sb.append(JSONWriter.list2JsonString((List)obj)).append(',');
                continue;
            }
            if (obj instanceof Object[]) {
                sb.append(JSONWriter.vector2JsonString((Object[])obj)).append(',');
                continue;
            }
            if (obj instanceof Map) {
                sb.append(JSONWriter.map2JsonString((Map)obj)).append(',');
                continue;
            }
            if (obj instanceof Boolean || obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double) {
                sb.append(obj.toString()).append(',');
                continue;
            }
            String v = obj.toString();
            int last = v.length() - 1;
            if (v.length() > 1 && (v.charAt(0) == '{' && v.charAt(last) == '}' || v.charAt(0) == '[' && v.charAt(last) == ']')) {
                sb.append(v).append(',');
                continue;
            }
            sb.append('\"').append(v).append("\",");
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append('}');
        return sb.toString();
    }
}

