/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server.controller;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.lionsoul.jcseg.extractor.impl.TextRankKeyphraseExtractor;
import org.lionsoul.jcseg.server.JcsegController;
import org.lionsoul.jcseg.server.JcsegGlobalResource;
import org.lionsoul.jcseg.server.JcsegTokenizerEntry;
import org.lionsoul.jcseg.server.core.GlobalResource;
import org.lionsoul.jcseg.server.core.ServerConfig;
import org.lionsoul.jcseg.server.core.UriEntry;
import org.lionsoul.jcseg.tokenizer.core.ISegment;
import org.lionsoul.jcseg.tokenizer.core.JcsegException;
import org.lionsoul.jcseg.tokenizer.core.SegmentFactory;

public class KeyphraseController
extends JcsegController {
    public KeyphraseController(ServerConfig config, GlobalResource globalResource, UriEntry uriEntry, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        super(config, globalResource, uriEntry, baseRequest, request, response);
    }

    @Override
    protected void run(String method) throws IOException {
        String text = this.getString("text");
        int number = this.getInt("number", 10);
        int maxCombineLength = this.getInt("maxCombineLength", 4);
        int autoMinLength = this.getInt("autoMinLength", 4);
        if (text == null || "".equals(text)) {
            this.response(1, "Invalid Arguments");
            return;
        }
        JcsegGlobalResource resourcePool = (JcsegGlobalResource)this.globalResource;
        JcsegTokenizerEntry tokenizerEntry = resourcePool.getTokenizerEntry("extractor");
        if (tokenizerEntry == null) {
            this.response(1, "can't find tokenizer instance \"extractor\"");
            return;
        }
        try {
            ISegment seg = SegmentFactory.createJcseg(2, tokenizerEntry.getConfig(), tokenizerEntry.getDict());
            TextRankKeyphraseExtractor extractor = new TextRankKeyphraseExtractor(seg);
            extractor.setKeywordsNum(number);
            extractor.setMaxWordsNum(maxCombineLength);
            extractor.setAutoMinLength(autoMinLength);
            long s_time = System.nanoTime();
            List<String> keyphrase = extractor.getKeyphraseFromString(text);
            double c_time = (double)(System.nanoTime() - s_time) / 1.0E9;
            HashMap<String, Object> map = new HashMap<String, Object>();
            DecimalFormat df = new DecimalFormat("0.00000");
            map.put("took", Float.valueOf(df.format(c_time)));
            map.put("keyphrase", keyphrase);
            this.response(0, map);
        }
        catch (JcsegException e) {
            this.response(-1, "Internal error...");
        }
    }
}

