/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server.core;

import java.util.HashMap;
import java.util.Map;
import org.lionsoul.jcseg.server.core.AbstractRouter;
import org.lionsoul.jcseg.server.core.Controller;
import org.lionsoul.jcseg.server.core.UriEntry;
import org.lionsoul.jcseg.server.util.LRUCache;

public class ContextRouter
extends AbstractRouter {
    private Map<String, Class<? extends Controller>> maps = new HashMap<String, Class<? extends Controller>>();
    private Map<String, Class<? extends Controller>> matches = new HashMap<String, Class<? extends Controller>>();
    private LRUCache<String, Class<? extends Controller>> cache = new LRUCache(128, 10);
    private static int MAP_PATH_TYPE = 1;
    private static int MATCH_PATH_TYPE = 2;

    public ContextRouter(Class<? extends Controller> defaultController) {
        super(defaultController);
    }

    private PathEntry getPathEntry(UriEntry uri) {
        PathEntry pathEntry = new PathEntry(MAP_PATH_TYPE, "default");
        int length = uri.getLength();
        if (length < 2) {
            return pathEntry;
        }
        String requestUri = uri.getRequestUri();
        String last_str = uri.get(length - 1);
        if (last_str.equals("*") || last_str.equals("")) {
            int lastPosition = requestUri.lastIndexOf(47);
            pathEntry.type = MATCH_PATH_TYPE;
            pathEntry.key = requestUri.substring(0, lastPosition + 1);
        } else {
            pathEntry.key = requestUri;
        }
        return pathEntry;
    }

    @Override
    public void addMapping(String path, Class<? extends Controller> _class) {
        UriEntry uri = new UriEntry(path);
        PathEntry entry = this.getPathEntry(uri);
        if (entry.type == MAP_PATH_TYPE) {
            if (entry.key.equals("default")) {
                _class = this.defaultController;
            }
            this.maps.put(entry.key, _class);
        } else if (entry.type == MATCH_PATH_TYPE) {
            this.matches.put(entry.key, _class);
        }
    }

    @Override
    public void removeMapping(String path) {
        UriEntry uri = new UriEntry(path);
        PathEntry pathEntry = this.getPathEntry(uri);
        if (pathEntry.type == MAP_PATH_TYPE) {
            this.maps.remove(pathEntry.key);
        } else if (pathEntry.type == MATCH_PATH_TYPE) {
            this.matches.remove(pathEntry.key);
        }
    }

    @Override
    public Class<? extends Controller> getController(UriEntry uriEntry) {
        PathEntry pathEntry = this.getPathEntry(uriEntry);
        Class<? extends Controller> controller = null;
        String uri = uriEntry.getRequestUri();
        if (pathEntry.type == MAP_PATH_TYPE) {
            controller = this.maps.get(pathEntry.key);
        }
        if (controller == null) {
            controller = this.cache.get(uri);
        }
        if (controller == null || pathEntry.type == MATCH_PATH_TYPE) {
            String key = uri;
            int lastPosition = key.lastIndexOf(47);
            while (lastPosition != -1) {
                controller = this.matches.get((key = key.substring(0, lastPosition)) + '/');
                if (controller != null) {
                    this.cache.set(uri, controller);
                    break;
                }
                lastPosition = key.lastIndexOf(47);
            }
        }
        return controller != null ? controller : this.defaultController;
    }

    private class PathEntry {
        public int type = 0;
        public String key = null;

        public PathEntry(int _type, String _key) {
            this.type = _type;
            this.key = _key;
        }
    }
}

