/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.server.core;

import java.io.IOException;
import java.lang.reflect.Constructor;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.lionsoul.jcseg.server.core.AbstractRouter;
import org.lionsoul.jcseg.server.core.Controller;
import org.lionsoul.jcseg.server.core.GlobalResource;
import org.lionsoul.jcseg.server.core.ServerConfig;
import org.lionsoul.jcseg.server.core.UriEntry;

public class StandardHandler
extends AbstractHandler {
    private ServerConfig serverConfig = null;
    private GlobalResource resourcePool = null;
    protected AbstractRouter router = null;

    public StandardHandler(ServerConfig serverConfig, GlobalResource resourcePool, AbstractRouter router) {
        this.serverConfig = serverConfig;
        this.resourcePool = resourcePool;
        this.router = router;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String requestUri = request.getRequestURI();
        if (requestUri.length() <= 1 || requestUri.indexOf(46) <= -1) {
            UriEntry uriEntry = UriEntry.parseRequestUri(request.getRequestURI());
            Class<? extends Controller> _class = this.router.getController(uriEntry);
            try {
                Class[] paramType = new Class[]{ServerConfig.class, GlobalResource.class, UriEntry.class, Request.class, HttpServletRequest.class, HttpServletResponse.class};
                Constructor<? extends Controller> constructor = _class.getConstructor(paramType);
                Object[] arguments = new Object[]{this.serverConfig, this.resourcePool, uriEntry, baseRequest, request, response};
                Controller controller = constructor.newInstance(arguments);
                controller.run(uriEntry.getMethod());
            }
            catch (Exception exception) {
                // empty catch block
            }
            baseRequest.setHandled(true);
        }
    }
}

