/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

import org.lionsoul.jcseg.tokenizer.Word;
import org.lionsoul.jcseg.tokenizer.core.IWord;

public class TimeUtil {
    public static final int DATETIME_NONE = -1;
    public static final int DATETIME_YV = 0;
    public static final int DATETIME_Y = 1;
    public static final int DATETIME_MV = 2;
    public static final int DATETIME_M = 3;
    public static final int DATETIME_DV = 4;
    public static final int DATETIME_D = 5;
    public static final int DATETIME_AV = 6;
    public static final int DATETIME_A = 7;
    public static final int DATETIME_HV = 8;
    public static final int DATETIME_H = 9;
    public static final int DATETIME_IV = 10;
    public static final int DATETIME_I = 11;
    public static final int DATETIME_SV = 12;
    public static final int DATETIME_S = 13;
    private static final String[] KeyMap = new String[]{"y", "y", "m", "m", "d", "d", "tm", "tm", "h", "h", "i", "i", "s", "s"};

    public static final int getDateTimeIndex(String entity) {
        if (entity == null) {
            return -1;
        }
        int aIdx = entity.indexOf(35);
        int sIdx = aIdx > -1 ? entity.indexOf(46, aIdx + 1) : entity.indexOf(46);
        if (sIdx == -1) {
            return -1;
        }
        String attr = entity.substring(sIdx + 1);
        if (attr.length() < 1) {
            return -1;
        }
        if (aIdx == -1) {
            if (attr.startsWith("y")) {
                return 1;
            }
            if (attr.startsWith("m")) {
                return 3;
            }
            if (attr.startsWith("d")) {
                return 5;
            }
            if (attr.startsWith("a")) {
                return 7;
            }
            if (attr.startsWith("h")) {
                return 9;
            }
            if (attr.startsWith("i")) {
                return 11;
            }
            if (attr.startsWith("s")) {
                return 13;
            }
        }
        if (attr.startsWith("y")) {
            return 0;
        }
        if (attr.startsWith("m")) {
            return 2;
        }
        if (attr.startsWith("d")) {
            return 4;
        }
        if (attr.startsWith("h")) {
            return 8;
        }
        if (attr.startsWith("i")) {
            return 10;
        }
        if (attr.startsWith("s")) {
            return 12;
        }
        return -1;
    }

    public static final IWord[] createDateTimePool() {
        return new IWord[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    }

    public static final int fillDateTimePool(IWord[] wPool, IWord word) {
        int pIdx = TimeUtil.getDateTimeIndex(word.getEntity(0));
        if (pIdx == -1) {
            return -1;
        }
        if (wPool[pIdx] == null) {
            wPool[pIdx] = word;
            return pIdx;
        }
        return -1;
    }

    public static final void fillDateTimePool(IWord[] wPool, int pIdx, IWord word) {
        if (wPool[pIdx] == null) {
            wPool[pIdx] = word;
        }
    }

    public static final String getTimeKey(String entity) {
        if (entity == null) {
            return null;
        }
        int aIdx = entity.indexOf(35);
        int sIdx = aIdx > -1 ? entity.indexOf(46, aIdx + 1) : entity.indexOf(46);
        return entity.substring(sIdx + 1);
    }

    public static final String getTimeKey(IWord word) {
        return TimeUtil.getTimeKey(word.getEntity(0));
    }

    public static final String getTimeKey(int pIdx) {
        if (pIdx < 0 || pIdx > 12) {
            return null;
        }
        return KeyMap[pIdx];
    }

    public static final void fillTimeToPool(IWord[] wPool, String timeVal) {
        String[] p = timeVal.split(":");
        TimeUtil.fillDateTimePool(wPool, 8, new Word(p[0], 5, new String[]{"time.h"}));
        TimeUtil.fillDateTimePool(wPool, 9, new Word("\u70b9", 1, new String[]{"time.h"}));
        TimeUtil.fillDateTimePool(wPool, 10, new Word(p[1], 5, new String[]{"time.i"}));
        TimeUtil.fillDateTimePool(wPool, 11, new Word("\u5206", 1, new String[]{"time.i"}));
        if (p.length == 3) {
            TimeUtil.fillDateTimePool(wPool, 12, new Word(p[2], 5, new String[]{"time.s"}));
            TimeUtil.fillDateTimePool(wPool, 13, new Word("\u79d2", 1, new String[]{"time.s"}));
        }
    }
}

