/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.amazon.s3;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.UnknownHostException;
import java.security.Security;
import java.text.DecimalFormat;
import java.util.LinkedList;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.amazon.s3.AmazonS3;
import org.lastbamboo.common.amazon.s3.AmazonS3Utils;
import org.lastbamboo.common.amazon.s3.GlobalOptions;
import org.lastbamboo.common.amazon.stack.AwsUtils;
import org.littleshoot.util.DateUtils;
import org.littleshoot.util.DefaultHttpClientImpl;
import org.littleshoot.util.FileInputStreamHandler;
import org.littleshoot.util.InputStreamHandler;
import org.littleshoot.util.NoOpInputStreamHandler;
import org.littleshoot.util.SecurityUtils;
import org.littleshoot.util.xml.XPathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AmazonS3Impl
implements AmazonS3 {
    private final Logger log = LoggerFactory.getLogger(AmazonS3Impl.class);
    private final String accessKeyId;
    private final String secretAccessKey;
    private String secureUrlBase;
    private String urlBase;
    private MimetypesFileTypeMap mimeMap;

    public AmazonS3Impl() throws IOException {
        if (!AwsUtils.hasPropsFile()) {
            System.out.println("No properties file found");
            throw new IOException("No props file");
        }
        try {
            this.accessKeyId = AwsUtils.getAccessKeyId();
        }
        catch (IOException e) {
            System.out.println("Found the properties file, but there's no access key ID in the form: accessKeyId=");
            throw e;
        }
        try {
            this.secretAccessKey = AwsUtils.getAccessKey();
        }
        catch (IOException e) {
            System.out.println("Found the properties file, but there's no secret access key in the form: accessKey=");
            throw e;
        }
        try {
            this.urlBase = AwsUtils.getUrlBase();
        }
        catch (IOException e) {
            System.out.println("No urlBase in properties file.");
            this.urlBase = "http://s3.amazonaws.com";
            throw e;
        }
        try {
            this.secureUrlBase = AwsUtils.getSecureUrlBase();
        }
        catch (IOException e) {
            System.out.println("No urlBase in properties file.");
            this.secureUrlBase = "https://s3.amazonaws.com:443";
        }
        AmazonS3Impl.configureDns();
        this.mimeMap = new MimetypesFileTypeMap();
        this.mimeMap.addMimeTypes("application/x-apple-diskimage dmg\n");
    }

    private static void configureDns() {
        int cacheSeconds = 3600000;
        Security.setProperty("networkaddress.cache.ttl", Integer.toString(3600000));
    }

    @Override
    public void getPrivateFile(String bucketName, String fileName, File target) throws IOException {
        String fullPath = bucketName + "/" + fileName;
        String url = this.secureUrlBase + "/" + fullPath;
        this.log.debug("Getting file from URL: " + url);
        GetMethod method = new GetMethod(url);
        this.normalizeRequest((HttpMethod)method, "GET", fullPath, false, true);
        FileInputStreamHandler handler = new FileInputStreamHandler(target);
        this.sendRequest((HttpMethod)method, (InputStreamHandler)handler);
    }

    @Override
    public void getPublicFile(String bucketName, String fileName, File target) throws IOException {
        String fullPath = bucketName + "/" + fileName;
        String url = this.urlBase + "/" + fullPath;
        this.log.debug("Getting file from URL: " + url);
        GetMethod method = new GetMethod(url);
        this.normalizeRequest((HttpMethod)method, "GET", fullPath, false, false);
        FileInputStreamHandler handler = new FileInputStreamHandler(target);
        this.sendRequest((HttpMethod)method, (InputStreamHandler)handler);
    }

    @Override
    public void putPrivateFile(String bucketName, File file) throws IOException {
        this.putFile(bucketName, file, false);
    }

    @Override
    public void putPrivateDir(String bucketName, File dir) throws IOException {
        File[] files;
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        };
        for (File file : files = dir.listFiles(filter)) {
            this.putPrivateFile(bucketName, file);
        }
    }

    @Override
    public void putPublicFile(String bucketName, File file) throws IOException {
        this.putFile(bucketName, file, true);
    }

    @Override
    public void putPublicFile(String bucketName, File file, String mimeType) throws IOException {
        this.putFile(bucketName, file, mimeType, true);
    }

    @Override
    public void putPublicDir(String bucketName, File dir) throws IOException {
        File[] files;
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        };
        for (File file : files = dir.listFiles(filter)) {
            this.putPublicFile(bucketName, file);
        }
    }

    private void putFile(String bucketName, File file, boolean makePublic) throws IOException {
        this.putFile(bucketName, file, this.mimeMap.getContentType(file), makePublic);
    }

    private void putFile(String bucketName, File file, String mimeType, boolean makePublic) throws IOException {
        try {
            FileRequestEntity re = new FileRequestEntity(file, mimeType);
            this.put(bucketName + "/" + file.getName(), (RequestEntity)re, makePublic);
        }
        catch (FileNotFoundException e) {
            this.log.error("File Not Found: " + file, (Throwable)e);
        }
    }

    @Override
    public void createBucket(String bucketName) throws IOException {
        this.put(bucketName, null, false);
    }

    @Override
    public void listBuckets() throws IOException {
        String url = "https://s3.amazonaws.com:443";
        this.log.debug("Sending to URL: https://s3.amazonaws.com:443");
        GetMethod method = new GetMethod("https://s3.amazonaws.com:443");
        InputStreamHandler handler = new InputStreamHandler(){

            public void handleInputStream(InputStream is) throws IOException {
                String xmlBody = IOUtils.toString((InputStream)is);
                try {
                    XPathUtils xPath = XPathUtils.newXPath((String)xmlBody);
                    String namePath = "/ListAllMyBucketsResult/Buckets/Bucket/Name";
                    String creationDatePath = "/ListAllMyBucketsResult/Buckets/Bucket/CreationDate";
                    NodeList nameNodes = xPath.getNodes("/ListAllMyBucketsResult/Buckets/Bucket/Name");
                    NodeList lmNodes = xPath.getNodes("/ListAllMyBucketsResult/Buckets/Bucket/CreationDate");
                    int charsSep = 46;
                    System.out.println("------------------------------------------------------------------------------");
                    StringBuilder desc = new StringBuilder();
                    desc.append("Name");
                    this.appendSpace(desc, 42);
                    desc.append("Creation Date");
                    System.out.println(desc.toString());
                    System.out.println("------------------------------------------------------------------------------");
                    System.out.println();
                    for (int i = 0; i < nameNodes.getLength(); ++i) {
                        Node nameNode = nameNodes.item(i);
                        String name = nameNode.getTextContent();
                        Node lmNode = lmNodes.item(i);
                        String lm = lmNode.getTextContent();
                        String dateString = DateUtils.prettyS3Date((String)lm);
                        StringBuilder sb = new StringBuilder();
                        sb.append(name);
                        this.appendSpace(sb, 46 - name.length());
                        sb.append(dateString);
                        System.out.println(sb.toString());
                    }
                }
                catch (SAXException e) {
                    AmazonS3Impl.this.log.warn("Exception with XML", (Throwable)e);
                }
                catch (XPathExpressionException e) {
                    AmazonS3Impl.this.log.warn("Exception with XPath", (Throwable)e);
                }
            }

            private void appendSpace(StringBuilder sb, int extraSpace) {
                for (int j = 0; j < extraSpace; ++j) {
                    sb.append(" ");
                }
            }
        };
        this.normalizeRequest((HttpMethod)method, "GET", "", false, true);
        this.sendRequest((HttpMethod)method, handler);
    }

    @Override
    public void listBucket(String bucketName) throws IOException {
        String fullPath = bucketName;
        String url = this.secureUrlBase + "/" + fullPath;
        this.log.debug("Sending to URL: " + url);
        GetMethod method = new GetMethod(url);
        InputStreamHandler handler = new InputStreamHandler(){

            public void handleInputStream(InputStream is) throws IOException {
                String xmlBody = IOUtils.toString((InputStream)is);
                try {
                    XPathUtils xPath = XPathUtils.newXPath((String)xmlBody);
                    String namePath = "/ListBucketResult/Contents/Key";
                    String lastModifiedPath = "/ListBucketResult/Contents/LastModified";
                    String sizePath = "/ListBucketResult/Contents/Size";
                    NodeList nameNodes = xPath.getNodes("/ListBucketResult/Contents/Key");
                    NodeList lmNodes = xPath.getNodes("/ListBucketResult/Contents/LastModified");
                    NodeList sizeNodes = xPath.getNodes("/ListBucketResult/Contents/Size");
                    System.out.println("------------------------------------------------------------------------------");
                    int sep1 = 30;
                    int sep2 = 26;
                    StringBuilder desc = new StringBuilder();
                    String desc1 = "Name";
                    String desc2 = "Last Modified";
                    String desc3 = "Size";
                    desc.append("Name");
                    this.appendSpace(desc, 30 - "Name".length());
                    desc.append("Last Modified");
                    this.appendSpace(desc, 26 - "Last Modified".length());
                    desc.append("Size");
                    System.out.println(desc.toString());
                    System.out.println("------------------------------------------------------------------------------");
                    System.out.println();
                    for (int i = 0; i < nameNodes.getLength(); ++i) {
                        Node nameNode = nameNodes.item(i);
                        String name = nameNode.getTextContent();
                        Node lmNode = lmNodes.item(i);
                        String lm = lmNode.getTextContent();
                        Node sizeNode = sizeNodes.item(i);
                        String sizeString = sizeNode.getTextContent();
                        int sizeInt = Integer.parseInt(sizeString);
                        double sizeK = sizeInt / 1024;
                        double sizeMb = sizeK / 1024.0;
                        String dateString = DateUtils.prettyS3Date((String)lm);
                        StringBuilder sb = new StringBuilder();
                        sb.append(name);
                        this.appendSpace(sb, 30 - name.length());
                        sb.append(dateString);
                        DecimalFormat df = new DecimalFormat("###0.##");
                        String formattedSize = df.format(sizeMb);
                        this.appendSpace(sb, 26 - dateString.length());
                        sb.append(formattedSize);
                        sb.append(" MB");
                        System.out.println(sb.toString());
                    }
                }
                catch (SAXException e) {
                    AmazonS3Impl.this.log.warn("Exception with XML", (Throwable)e);
                }
                catch (XPathExpressionException e) {
                    AmazonS3Impl.this.log.warn("Exception with XPath", (Throwable)e);
                }
            }

            private void appendSpace(StringBuilder sb, int extraSpace) {
                for (int j = 0; j < extraSpace; ++j) {
                    sb.append(" ");
                }
            }
        };
        this.normalizeRequest((HttpMethod)method, "GET", fullPath, false, true);
        this.sendRequest((HttpMethod)method, handler);
    }

    @Override
    public void deleteBucket(String bucketName) throws IOException {
        this.delete(bucketName);
    }

    @Override
    public void delete(String bucketName, String fileName) throws IOException {
        System.out.println("Deleting " + fileName);
        this.delete(bucketName + "/" + fileName);
    }

    @Override
    public void deleteStar(String bucketName, String fileName) throws IOException {
        String fullPath = bucketName;
        String url = this.secureUrlBase + "/" + fullPath;
        this.log.debug("Sending to URL: " + url);
        final LinkedList filesToDelete = new LinkedList();
        GetMethod method = new GetMethod(url);
        boolean matchStartTemp = false;
        String toMatchTemp = fileName;
        boolean matchEndTemp = false;
        if (!fileName.endsWith("*") && !fileName.startsWith("*")) {
            this.delete(bucketName, fileName);
            return;
        }
        if (fileName.endsWith("*")) {
            matchStartTemp = true;
            toMatchTemp = toMatchTemp.substring(0, fileName.length() - 1);
            this.log.debug("Checking for files that start with: " + toMatchTemp);
        }
        if (fileName.startsWith("*")) {
            matchEndTemp = true;
            toMatchTemp = toMatchTemp.substring(1);
            this.log.debug("Checking for files that end with: " + toMatchTemp);
        }
        this.log.debug("Checking for files matching: " + toMatchTemp);
        final boolean matchStart = matchStartTemp;
        final boolean matchEnd = matchEndTemp;
        final String toMatch = toMatchTemp;
        InputStreamHandler handler = new InputStreamHandler(){

            public void handleInputStream(InputStream is) throws IOException {
                String xmlBody = IOUtils.toString((InputStream)is);
                try {
                    XPathUtils xPath = XPathUtils.newXPath((String)xmlBody);
                    String namePath = "/ListBucketResult/Contents/Key";
                    NodeList nameNodes = xPath.getNodes("/ListBucketResult/Contents/Key");
                    for (int i = 0; i < nameNodes.getLength(); ++i) {
                        Node nameNode = nameNodes.item(i);
                        String name = nameNode.getTextContent();
                        if (matchStart && name.startsWith(toMatch)) {
                            AmazonS3Impl.this.log.debug("Matched: " + name);
                            filesToDelete.add(name);
                            continue;
                        }
                        if (!matchEnd || !name.endsWith(toMatch)) continue;
                        AmazonS3Impl.this.log.debug("Matched: " + name);
                        filesToDelete.add(name);
                    }
                }
                catch (SAXException e) {
                    AmazonS3Impl.this.log.warn("Exception with XML", (Throwable)e);
                }
                catch (XPathExpressionException e) {
                    AmazonS3Impl.this.log.warn("Exception with XPath", (Throwable)e);
                }
            }
        };
        this.normalizeRequest((HttpMethod)method, "GET", fullPath, false, true);
        this.sendRequest((HttpMethod)method, handler);
        for (String fileKey : filesToDelete) {
            this.delete(bucketName, fileKey);
        }
    }

    private void delete(String relativePath) throws IOException {
        String fullPath = relativePath;
        String url = this.secureUrlBase + "/" + fullPath;
        this.log.debug("Sending to URL: " + url);
        DeleteMethod method = new DeleteMethod(url);
        NoOpInputStreamHandler handler = new NoOpInputStreamHandler();
        this.normalizeRequest((HttpMethod)method, "DELETE", fullPath, false, true);
        this.sendRequest((HttpMethod)method, (InputStreamHandler)handler);
    }

    private void put(String relativePath, RequestEntity re, boolean isPublic) throws IOException {
        String fullPath = relativePath;
        String url = this.secureUrlBase + "/" + fullPath;
        this.log.debug("Sending to URL: " + url);
        PutMethod method = new PutMethod(url);
        if (re != null) {
            method.setRequestEntity(re);
            method.setRequestHeader("Content-Type", re.getContentType());
        } else {
            method.setRequestHeader("Content-Type", "");
        }
        NoOpInputStreamHandler handler = new NoOpInputStreamHandler();
        this.normalizeRequest((HttpMethod)method, "PUT", fullPath, isPublic, true);
        this.sendRequest((HttpMethod)method, (InputStreamHandler)handler);
    }

    @Override
    public void normalizeRequest(HttpMethod method, String methodString, String fullPath, boolean addPublicHeader, boolean useAuth) {
        Header dateHeader = new Header("Date", DateUtils.createHttpDate());
        method.setRequestHeader(dateHeader);
        if (addPublicHeader) {
            Header publicHeader = new Header("x-amz-acl", "public-read");
            method.setRequestHeader(publicHeader);
        }
        try {
            URI uri = method.getURI();
            this.log.info("Using URI: {}", (Object)uri);
            String host = uri.getHost();
            if (host.contains("archive.org")) {
                method.addRequestHeader("x-amz-auto-make-bucket", "1");
            }
        }
        catch (URIException e) {
            e.printStackTrace();
        }
        if (useAuth) {
            Header auth = this.createAuthHeader(method, methodString, fullPath);
            method.setRequestHeader(auth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(HttpMethod method, InputStreamHandler handler) throws IOException {
        DefaultHttpClientImpl client = new DefaultHttpClientImpl();
        HttpMethodRetryHandler retryHandler = new HttpMethodRetryHandler(){

            public boolean retryMethod(HttpMethod method, IOException ioe, int retries) {
                if (ioe instanceof UnknownHostException) {
                    return false;
                }
                if (retries < 40) {
                    System.out.println("Did not connect.  Received: ");
                    ioe.printStackTrace();
                    try {
                        Thread.sleep(retries * 200);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    return true;
                }
                return false;
            }
        };
        method.getParams().setParameter("http.method.retry-handler", (Object)retryHandler);
        if (StringUtils.isNotBlank((String)GlobalOptions.getProxyHost()) && GlobalOptions.getProxyPort() > 0) {
            this.log.debug("Setting proxy!!");
            client.getHostConfiguration().setProxy(GlobalOptions.getProxyHost(), GlobalOptions.getProxyPort());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("HTTP request headers: ");
            this.printHeaders(method.getRequestHeaders());
        }
        try {
            client.executeMethod(method);
            StatusLine statusLine = method.getStatusLine();
            int code = statusLine.getStatusCode();
            if (code < 200 || code > 299) {
                this.log.debug("Did not receive 200 level response: " + statusLine);
                Header[] responseHeaders = method.getResponseHeaders();
                this.printHeaders(responseHeaders);
                InputStream is = method.getResponseBodyAsStream();
                String response = IOUtils.toString((InputStream)is);
                String msg = statusLine + "\nwith body:\n" + response;
                this.log.debug("Got response: " + msg);
                IOUtils.closeQuietly((InputStream)is);
                throw new IOException("Error accessing S3: " + msg);
            }
            InputStream body = method.getResponseBodyAsStream();
            handler.handleInputStream(body);
        }
        finally {
            method.releaseConnection();
        }
    }

    private Header createAuthHeader(HttpMethod method, String methodString, String fullPath) {
        String canonicalString = AmazonS3Utils.makeCanonicalString(methodString, fullPath, method.getRequestHeaders());
        this.log.debug("Using canonical string: " + canonicalString);
        String encodedCanonical = SecurityUtils.signAndEncode((String)this.secretAccessKey, (String)canonicalString);
        String authValue = "AWS " + this.accessKeyId + ":" + encodedCanonical;
        Header auth = new Header("Authorization", authValue);
        return auth;
    }

    private void printHeaders(Header[] headers) {
        for (int i = 0; i < headers.length; ++i) {
            Header rh = headers[i];
            this.log.debug(rh.toString());
        }
    }
}

