/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.amazon.s3;

import java.util.TreeMap;
import org.apache.commons.httpclient.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmazonS3Utils {
    private static final Logger LOG = LoggerFactory.getLogger(AmazonS3Utils.class);
    private static final String AMAZON_HEADER_PREFIX = "x-amz-";
    private static final String ALTERNATIVE_DATE_HEADER = "x-amz-date";

    public static String makeCanonicalString(String method, String resource, Header[] headers) {
        return AmazonS3Utils.makeCanonicalString(method, resource, headers, null);
    }

    private static String makeCanonicalString(String method, String resource, Header[] headers, String expires) {
        StringBuilder buf = new StringBuilder();
        buf.append(method);
        buf.append("\n");
        TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
        if (headers != null) {
            for (Header curHeader : headers) {
                String lk = curHeader.getName().toLowerCase();
                if (!lk.equals("content-type") && !lk.equals("content-md5") && !lk.equals("date") && !lk.startsWith(AMAZON_HEADER_PREFIX)) continue;
                String headersList = curHeader.getValue();
                LOG.debug("Our headers list: " + headersList);
                interestingHeaders.put(lk, headersList);
            }
        }
        if (interestingHeaders.containsKey(ALTERNATIVE_DATE_HEADER)) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        if (!interestingHeaders.containsKey("content-md5")) {
            interestingHeaders.put("content-md5", "");
        }
        for (String key : interestingHeaders.keySet()) {
            if (key.startsWith(AMAZON_HEADER_PREFIX)) {
                buf.append(key).append(':').append((String)interestingHeaders.get(key));
            } else {
                buf.append((String)interestingHeaders.get(key));
            }
            buf.append("\n");
        }
        int queryIndex = resource.indexOf(63);
        if (queryIndex == -1) {
            buf.append("/" + resource);
        } else {
            buf.append("/" + resource.substring(0, queryIndex));
        }
        if (resource.matches(".*[&?]acl($|=|&).*")) {
            buf.append("?acl");
        } else if (resource.matches(".*[&?]torrent($|=|&).*")) {
            buf.append("?torrent");
        } else if (resource.matches(".*[&?]logging($|=|&).*")) {
            buf.append("?logging");
        }
        return buf.toString();
    }
}

