/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.amazon.s3;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.prefs.Preferences;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.lastbamboo.common.amazon.s3.AmazonS3;
import org.lastbamboo.common.amazon.s3.AmazonS3Impl;
import org.lastbamboo.common.amazon.s3.GlobalOptions;
import org.lastbamboo.common.amazon.stack.AwsUtils;
import org.littleshoot.util.Pair;
import org.littleshoot.util.PairImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    private static final Logger LOG = LoggerFactory.getLogger(Launcher.class);
    private static final String BUCKETS_KEY = "littleShootS3Buckets";

    public static void main(String[] args) {
        Command bean = new Command();
        bean.execute(args);
    }

    private static void createBucket(String bucketName, AmazonS3 s3) {
        try {
            if (AwsUtils.getUrlBase().contains("archive.org")) {
                System.out.println("Not creating bucket for URL base: " + AwsUtils.getUrlBase());
                return;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Preferences prefs = Preferences.userRoot();
        String createdBuckets = prefs.get(BUCKETS_KEY, "");
        if (!createdBuckets.contains("," + bucketName + ",") && !createdBuckets.endsWith("," + bucketName)) {
            try {
                s3.createBucket(bucketName);
                prefs.put(BUCKETS_KEY, createdBuckets + "," + bucketName);
            }
            catch (IOException e) {
                System.out.println("Could not create bucket. Already exists?");
                e.printStackTrace();
            }
        }
    }

    private static void deleteBucket(String bucketName, AmazonS3 s3) {
        Preferences prefs = Preferences.userRoot();
        String createdBuckets = prefs.get(BUCKETS_KEY, "");
        try {
            s3.deleteBucket(bucketName);
            if (createdBuckets.contains("," + bucketName + ",")) {
                prefs.put(BUCKETS_KEY, createdBuckets.replace("," + bucketName + ",", ","));
            } else if (createdBuckets.endsWith("," + bucketName)) {
                String strippedBuckets = StringUtils.substringBeforeLast((String)createdBuckets, (String)("," + bucketName));
                prefs.put(BUCKETS_KEY, strippedBuckets);
            }
        }
        catch (IOException e) {
            System.out.println("Could not delete bucket.");
            e.printStackTrace();
        }
    }

    private static AmazonS3 setup(String[] args, int length, String message) {
        Launcher.checkArgs(args, length, message);
        try {
            return new AmazonS3Impl();
        }
        catch (IOException e) {
            System.out.println("Error loading props files...");
            throw new IllegalArgumentException("Error loading props files", e);
        }
    }

    private static void checkArgs(String[] args, int length, String message) {
        if (args.length < length) {
            StringBuilder sb = new StringBuilder();
            sb.append("Too few args.  Expected " + length);
            sb.append(" but found " + args.length);
            sb.append(" in ");
            for (String arg : args) {
                sb.append(arg);
                sb.append(" ");
            }
            System.err.println(sb);
            System.exit(1);
        }
    }

    private static class DeleteBucket
    implements ArgsProcessor {
        private DeleteBucket() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 1, "bucketName");
            String bucketName = args[0];
            Launcher.deleteBucket(bucketName, s3);
        }
    }

    private static class CreateBucket
    implements ArgsProcessor {
        private CreateBucket() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 1, "bucketName");
            String bucketName = args[0];
            try {
                s3.createBucket(bucketName);
            }
            catch (IOException e) {
                System.out.println("There was an error creating the bucket.");
                e.printStackTrace();
            }
        }
    }

    private static class ListBucket
    implements ArgsProcessor {
        private ListBucket() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 0, "bucketName");
            if (args.length == 0) {
                try {
                    s3.listBuckets();
                }
                catch (IOException e) {
                    System.out.println("There was an error listing the bucket.");
                    e.printStackTrace();
                }
            } else {
                String bucketName = args[0];
                try {
                    s3.listBucket(bucketName);
                }
                catch (IOException e) {
                    System.out.println("There was an error listing the bucket.");
                    e.printStackTrace();
                }
            }
        }
    }

    private static class Get
    implements ArgsProcessor {
        private Get() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 2, "bucketName fileName");
            String bucketName = args[0];
            String fileName = args[1];
            File target = new File(fileName);
            try {
                s3.getPrivateFile(bucketName, fileName, target);
            }
            catch (IOException e) {
                System.out.println("There was an error getting the file.");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static class PutPublicMime
    implements ArgsProcessor {
        private PutPublicMime() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 3, "bucketName fileName mimeType");
            String bucketName = args[0];
            Launcher.createBucket(bucketName, s3);
            String fileString = args[1];
            File file = new File(fileString);
            if (!file.isFile()) {
                System.out.println("File not found: " + fileString);
                return;
            }
            String mimeType = args[2];
            try {
                s3.putPublicFile(bucketName, file, mimeType);
            }
            catch (IOException e) {
                System.out.println("Could not upload file.  Error was: ");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static class PutPublic
    implements ArgsProcessor {
        private PutPublic() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 2, "bucketName fileName");
            String bucketName = args[0];
            Launcher.createBucket(bucketName, s3);
            String fileString = args[1];
            File file = new File(fileString);
            if (!file.isFile()) {
                System.out.println("File not found: " + fileString);
                return;
            }
            try {
                s3.putPublicFile(bucketName, file);
            }
            catch (IOException e) {
                System.out.println("Could not upload file.  Error was: ");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static class PutPrivate
    implements ArgsProcessor {
        private PutPrivate() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 2, "bucketName fileName");
            String bucketName = args[0];
            Launcher.createBucket(bucketName, s3);
            String fileString = args[1];
            File file = new File(fileString);
            if (!file.isFile()) {
                System.out.println("File not found: " + fileString);
                System.exit(1);
            }
            try {
                s3.putPrivateFile(bucketName, file);
            }
            catch (IOException e) {
                System.out.println("Could not upload file.  Error was: ");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static class Delete
    implements ArgsProcessor {
        private Delete() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 2, "bucketName name where name is has a '*' prefix or suffix, or both");
            String bucketName = args[0];
            String regEx = args[1];
            try {
                s3.deleteStar(bucketName, regEx);
            }
            catch (IOException e) {
                System.out.println("Could not delete regex: " + regEx);
                e.printStackTrace();
            }
        }
    }

    private static class PutAllPublic
    implements ArgsProcessor {
        private PutAllPublic() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 2, "bucketName directoryPath");
            String bucketName = args[0];
            File dir = new File(args[1]);
            if (!dir.isDirectory()) {
                System.out.println(dir + " does not appear to be a valid directory.");
                return;
            }
            try {
                s3.putPublicDir(bucketName, dir);
            }
            catch (IOException e) {
                System.out.println("Could not put all files.");
                e.printStackTrace();
            }
        }
    }

    private static class ProxyProcessor
    implements ArgsProcessor {
        private ProxyProcessor() {
        }

        @Override
        public void processArgs(String[] values) {
            LOG.debug("Processing proxy");
            String hostPort = values[0];
            String host = StringUtils.substringBefore((String)hostPort, (String)":");
            if (StringUtils.isBlank((String)host)) {
                System.err.println("Format: host:port");
                return;
            }
            String portStr = StringUtils.substringAfter((String)hostPort, (String)":");
            if (!StringUtils.isNumeric((String)portStr)) {
                System.err.println("Format: host:port");
                return;
            }
            int port = Integer.parseInt(portStr);
            LOG.debug("Setting proxy data");
            GlobalOptions.setProxyHost(host);
            GlobalOptions.setProxyPort(port);
        }
    }

    private static class PutAllPrivate
    implements ArgsProcessor {
        private PutAllPrivate() {
        }

        @Override
        public void processArgs(String[] args) {
            AmazonS3 s3 = Launcher.setup(args, 2, "bucketName directoryPath");
            String bucketName = args[0];
            File dir = new File(args[1]);
            if (!dir.isDirectory()) {
                System.out.println(dir + " does not appear to be a valid directory.");
                return;
            }
            try {
                s3.putPrivateDir(bucketName, dir);
            }
            catch (IOException e) {
                System.out.println("Could not put all files.");
                e.printStackTrace();
            }
        }
    }

    private static interface ArgsProcessor {
        public void processArgs(String[] var1);
    }

    private static final class Command {
        private final Collection<Pair<Option, ArgsProcessor>> optionsPairs = new ArrayList<Pair<Option, ArgsProcessor>>();
        private final Options options = new Options();

        private Command() {
        }

        private void add(Option opt, String desc, int numArgs, ArgsProcessor processor) {
            this.add(opt, desc, numArgs, processor, false);
        }

        private void add(Option opt, String desc, int numArgs, ArgsProcessor processor, boolean optional) {
            this.addOpt(opt, desc, numArgs, optional);
            this.optionsPairs.add((Pair<Option, ArgsProcessor>)new PairImpl((Object)opt, (Object)processor));
        }

        private void addOpt(Option opt, String desc, int numArgs, boolean optional) {
            opt.setArgs(numArgs);
            opt.setValueSeparator(' ');
            opt.setArgName(desc);
            opt.setOptionalArg(optional);
            this.options.addOption(opt);
        }

        private void execute(String[] args) {
            String bucketFile = "bucket, file";
            String bucketDir = "bucket, dir";
            String bucket = "bucket";
            this.options.addOption("h", "help", false, "Print this message.");
            Option get = new Option("get", "getfile", true, "Gets the specified file.");
            this.add(get, "bucket, file", 2, new Get());
            Option putPrivate = new Option("put", "putprivate", true, "Adds the specified file to S3 as a private file.");
            this.add(putPrivate, "bucket, file", 2, new PutPrivate());
            Option putPublic = new Option("putp", "putpublic", true, "Adds the specified file to S3 as publicly readable.");
            this.add(putPublic, "bucket, file", 2, new PutPublic());
            Option putPublicMime = new Option("putpm", "putpublicmime", true, "Adds the specified file to S3 as publicly readable with a custom mime type.");
            this.add(putPublicMime, "bucket, file", 3, new PutPublicMime());
            Option putAllPrivate = new Option("puta", "putall", true, "Adds all files in the specified directory as private files.");
            this.add(putAllPrivate, "bucket, dir", 2, new PutAllPrivate());
            Option putAllPublic = new Option("putap", "putallpublic", true, "Adds all files in the specified directory as public files.  Does not add directories or recurse.");
            this.add(putAllPublic, "bucket, dir", 2, new PutAllPublic());
            Option proxy = new Option("x", "proxy", true, "Sets the proxy to use.");
            this.add(proxy, "host:port", 1, new ProxyProcessor());
            Option delete = new Option("rm", "delete", true, "Removes the file in the specified bucket with the specified name.  Note that a '*' at the beginning or the end acts as a wildcard.  For example,'aws -rm littleshoot *.sh' removes all .sh files in the littleshoot bucket.  Use the star functionality with some caution, of course.  It only works at the beginning or end of the file name.");
            this.add(delete, "bucket, file", 2, new Delete());
            Option deleteBucket = new Option("rmdir", "deletebucket", true, "Removes the specified bucket if it's empty.");
            this.add(deleteBucket, "bucket", 1, new DeleteBucket());
            Option newBucket = new Option("mkdir", "makebucket", true, "Creates the specified bucket.");
            this.add(newBucket, "bucket", 1, new CreateBucket());
            Option listBucket = new Option("ls", "listbucket", true, "Lists all the files in the specified bucket.  Lists all buckets if no bucket name is given.");
            this.add(listBucket, "bucket", 1, new ListBucket(), true);
            Option verbose = new Option("v", "verbose", false, "Provides verbose output.");
            this.options.addOption(verbose);
            GnuParser parser = new GnuParser();
            try {
                CommandLine cmd = parser.parse(this.options, args);
                if (cmd.hasOption(verbose.getOpt())) {
                    // empty if block
                }
                if (cmd.hasOption(proxy.getOpt())) {
                    String[] values = Command.convertVals(cmd, proxy);
                    ProxyProcessor processor = new ProxyProcessor();
                    processor.processArgs(values);
                }
                for (Pair<Option, ArgsProcessor> optionPair : this.optionsPairs) {
                    Option opt = (Option)optionPair.getFirst();
                    if (!cmd.hasOption(opt.getOpt())) continue;
                    ArgsProcessor processor = (ArgsProcessor)optionPair.getSecond();
                    String[] values = Command.convertVals(cmd, opt);
                    processor.processArgs(values);
                }
                if (args.length == 0 || cmd.hasOption("h")) {
                    this.printHelp();
                } else if (cmd.getOptions().length == 0) {
                    System.err.println("Could not understand the options you specified.  Printing help.");
                    this.printHelp();
                    System.out.println();
                    System.err.println("Could not understand the options you specified.  See above help.");
                }
            }
            catch (ParseException e) {
                System.err.println(e.getMessage());
            }
        }

        private static String[] convertVals(CommandLine cmd, Option opt) {
            String[] values = cmd.getOptionValues(opt.getOpt());
            if (values == null) {
                return new String[0];
            }
            return values;
        }

        private void printHelp() {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("aws", this.options);
        }
    }
}

