/*
 * Decompiled with CFR 0.152.
 */
package org.lastbamboo.common.amazon.stack;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AwsUtils.class);

    private AwsUtils() {
    }

    public static String getAccessKey() throws IOException {
        return AwsUtils.getStringValue("accessKey");
    }

    public static String getAccessKeyId() throws IOException {
        return AwsUtils.getStringValue("accessKeyId");
    }

    public static String getUrlBase() throws IOException {
        return AwsUtils.getStringValue("urlBase", "http://s3.amazonaws.com");
    }

    public static String getSecureUrlBase() throws IOException {
        return AwsUtils.getStringValue("secureUrlBase", "https://s3.amazonaws.com:443");
    }

    private static String getStringValue(String key) throws IOException {
        Properties props = AwsUtils.locatePropsFile();
        String prop = props.getProperty(key);
        if (StringUtils.isBlank((String)prop)) {
            throw new IOException("Could not find value for key: " + key);
        }
        return prop;
    }

    private static String getStringValue(String key, String fallback) throws IOException {
        Properties props = AwsUtils.locatePropsFile();
        String prop = props.getProperty(key);
        if (StringUtils.isBlank((String)prop)) {
            return fallback;
        }
        return prop;
    }

    private static Properties locatePropsFile() throws IOException {
        File lsDir = new File(SystemUtils.USER_HOME, ".littleshoot");
        File home = new File(lsDir, "littleshoot.properties");
        if (home.isFile()) {
            return AwsUtils.createPropsFile(home);
        }
        File etc = new File("/etc/littleshoot/littleshoot.properties");
        if (etc.isFile()) {
            return AwsUtils.createPropsFile(etc);
        }
        throw new IOException("Could not find props file in " + lsDir + " or in " + home);
    }

    private static Properties createPropsFile(File file) throws IOException {
        Properties props = new Properties();
        FileInputStream is = new FileInputStream(file);
        props.load(is);
        ((InputStream)is).close();
        return props;
    }

    public static boolean hasPropsFile() {
        try {
            AwsUtils.locatePropsFile();
            return true;
        }
        catch (IOException e) {
            LOG.debug("No props file found", (Throwable)e);
            return false;
        }
    }
}

